/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.macs;

import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DataLengthException;
import org.openecard.bouncycastle.crypto.Mac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.util.Pack;
import org.openecard.bouncycastle.util.Arrays;

public class SipHash
implements Mac {
    protected final int c;
    protected final int d;
    protected long k0;
    protected long k1;
    protected long v0;
    protected long v1;
    protected long v2;
    protected long v3;
    protected long v4;
    protected byte[] buf = new byte[8];
    protected int bufPos = 0;
    protected int wordCount = 0;

    public SipHash() {
        this.c = 2;
        this.d = 4;
    }

    public SipHash(int c, int d) {
        this.c = c;
        this.d = d;
    }

    @Override
    public String getAlgorithmName() {
        return "SipHash-" + this.c + "-" + this.d;
    }

    @Override
    public int getMacSize() {
        return 8;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("'params' must be an instance of KeyParameter");
        }
        KeyParameter keyParameter = (KeyParameter)params;
        byte[] key = keyParameter.getKey();
        if (key.length != 16) {
            throw new IllegalArgumentException("'params' must be a 128-bit key");
        }
        this.k0 = Pack.littleEndianToLong(key, 0);
        this.k1 = Pack.littleEndianToLong(key, 8);
        this.reset();
    }

    @Override
    public void update(byte input) throws IllegalStateException {
        this.buf[this.bufPos] = input;
        if (++this.bufPos == this.buf.length) {
            this.processMessageWord();
            this.bufPos = 0;
        }
    }

    @Override
    public void update(byte[] input, int offset, int length) throws DataLengthException, IllegalStateException {
        for (int i = 0; i < length; ++i) {
            this.buf[this.bufPos] = input[offset + i];
            if (++this.bufPos != this.buf.length) continue;
            this.processMessageWord();
            this.bufPos = 0;
        }
    }

    public long doFinal() throws DataLengthException, IllegalStateException {
        this.buf[7] = (byte)((this.wordCount << 3) + this.bufPos & 0xFF);
        while (this.bufPos < 7) {
            this.buf[this.bufPos++] = 0;
        }
        this.processMessageWord();
        this.v2 ^= 0xFFL;
        this.applySipRounds(this.d);
        long result = this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        this.reset();
        return result;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long result = this.doFinal();
        Pack.longToLittleEndian(result, out, outOff);
        return 8;
    }

    @Override
    public void reset() {
        this.v0 = this.k0 ^ 0x736F6D6570736575L;
        this.v1 = this.k1 ^ 0x646F72616E646F6DL;
        this.v2 = this.k0 ^ 0x6C7967656E657261L;
        this.v3 = this.k1 ^ 0x7465646279746573L;
        Arrays.fill(this.buf, (byte)0);
        this.bufPos = 0;
        this.wordCount = 0;
    }

    protected void processMessageWord() {
        ++this.wordCount;
        long m = Pack.littleEndianToLong(this.buf, 0);
        this.v3 ^= m;
        this.applySipRounds(this.c);
        this.v0 ^= m;
    }

    protected void applySipRounds(int n) {
        for (int r = 0; r < n; ++r) {
            this.v0 += this.v1;
            this.v2 += this.v3;
            this.v1 = SipHash.rotateLeft(this.v1, 13);
            this.v3 = SipHash.rotateLeft(this.v3, 16);
            this.v1 ^= this.v0;
            this.v3 ^= this.v2;
            this.v0 = SipHash.rotateLeft(this.v0, 32);
            this.v2 += this.v1;
            this.v0 += this.v3;
            this.v1 = SipHash.rotateLeft(this.v1, 17);
            this.v3 = SipHash.rotateLeft(this.v3, 21);
            this.v1 ^= this.v2;
            this.v3 ^= this.v0;
            this.v2 = SipHash.rotateLeft(this.v2, 32);
        }
    }

    protected static long rotateLeft(long x, int n) {
        return x << n | x >>> 64 - n;
    }
}

