/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.sal;

import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSessionResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDCreate;
import iso.std.iso_iec._24727.tech.schema.DIDCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDDelete;
import iso.std.iso_iec._24727.tech.schema.DIDDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DIDUpdate;
import iso.std.iso_iec._24727.tech.schema.DIDUpdateResponse;
import iso.std.iso_iec._24727.tech.schema.Decipher;
import iso.std.iso_iec._24727.tech.schema.DecipherResponse;
import iso.std.iso_iec._24727.tech.schema.Encipher;
import iso.std.iso_iec._24727.tech.schema.EncipherResponse;
import iso.std.iso_iec._24727.tech.schema.GetRandom;
import iso.std.iso_iec._24727.tech.schema.GetRandomResponse;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import iso.std.iso_iec._24727.tech.schema.RequestType;
import iso.std.iso_iec._24727.tech.schema.ResponseType;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificate;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifySignature;
import iso.std.iso_iec._24727.tech.schema.VerifySignatureResponse;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.addon.sal.SALProtocol;
import org.openecard.common.WSHelper;

public abstract class SALProtocolBaseImpl
implements SALProtocol {
    protected final TreeMap<String, Object> internalData = new TreeMap();
    protected final ArrayList<ProtocolStep<?, ?>> steps = new ArrayList();
    protected final Map<FunctionType, ProtocolStep<?, ?>> statelessSteps = new EnumMap(FunctionType.class);
    protected int curStep = 0;

    protected SALProtocolBaseImpl() {
    }

    public TreeMap<String, Object> getInternalData() {
        return this.internalData;
    }

    private boolean hasNextStep() {
        return this.steps.size() > this.curStep;
    }

    private boolean hasNextProcessStep(FunctionType functionName) {
        if (this.hasNextStep()) {
            return this.steps.get(this.curStep).getFunctionType() == functionName;
        }
        return false;
    }

    private boolean hasStatelessStep(FunctionType functionName) {
        return this.statelessSteps.containsKey((Object)functionName);
    }

    @Override
    public boolean hasNextStep(FunctionType functionName) {
        if (this.hasStatelessStep(functionName)) {
            return true;
        }
        return this.hasNextProcessStep(functionName);
    }

    @Override
    public boolean isFinished() {
        return !this.hasNextStep();
    }

    @Nonnull
    protected ProtocolStep<?, ?> addOrderStep(@Nonnull ProtocolStep<?, ?> step) {
        this.steps.add(step);
        return step;
    }

    @Nullable
    protected ProtocolStep<?, ?> addStatelessStep(@Nonnull ProtocolStep<?, ?> step) {
        return this.statelessSteps.put(step.getFunctionType(), step);
    }

    private ProtocolStep<? extends RequestType, ? extends ResponseType> next(FunctionType functionName) {
        if (this.hasNextProcessStep(functionName)) {
            ProtocolStep<?, ?> step = this.steps.get(this.curStep);
            ++this.curStep;
            return step;
        }
        return this.statelessSteps.get((Object)functionName);
    }

    private static <Req extends RequestType> ResponseType perform(Class<? extends ResponseType> responseClass, ProtocolStep step, Req request, TreeMap<String, Object> internalData) {
        if (step == null) {
            String msg = "There is no applicable protocol step at this point in the protocol flow.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#inappropriateProtocolForAction", msg);
            return (ResponseType)WSHelper.makeResponse(responseClass, r);
        }
        return step.perform(request, internalData);
    }

    @Override
    public CardApplicationStartSessionResponse cardApplicationStartSession(CardApplicationStartSession param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.CardApplicationStartSession);
        Class<CardApplicationStartSessionResponse> c = CardApplicationStartSessionResponse.class;
        return (CardApplicationStartSessionResponse)SALProtocolBaseImpl.perform(c, s, param, this.internalData);
    }

    @Override
    public CardApplicationEndSessionResponse cardApplicationEndSession(CardApplicationEndSession param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.CardApplicationEndSession);
        Class<CardApplicationEndSessionResponse> c = CardApplicationEndSessionResponse.class;
        return (CardApplicationEndSessionResponse)SALProtocolBaseImpl.perform(c, s, param, this.internalData);
    }

    @Override
    public EncipherResponse encipher(Encipher param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.Encipher);
        return (EncipherResponse)SALProtocolBaseImpl.perform(EncipherResponse.class, s, param, this.internalData);
    }

    @Override
    public DecipherResponse decipher(Decipher param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.Decipher);
        return (DecipherResponse)SALProtocolBaseImpl.perform(DecipherResponse.class, s, param, this.internalData);
    }

    @Override
    public GetRandomResponse getRandom(GetRandom param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.GetRandom);
        return (GetRandomResponse)SALProtocolBaseImpl.perform(GetRandomResponse.class, s, param, this.internalData);
    }

    @Override
    public HashResponse hash(Hash param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.Hash);
        return (HashResponse)SALProtocolBaseImpl.perform(HashResponse.class, s, param, this.internalData);
    }

    @Override
    public SignResponse sign(Sign param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.Sign);
        return (SignResponse)SALProtocolBaseImpl.perform(SignResponse.class, s, param, this.internalData);
    }

    @Override
    public VerifySignatureResponse verifySignature(VerifySignature param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.VerifySignature);
        return (VerifySignatureResponse)SALProtocolBaseImpl.perform(VerifySignatureResponse.class, s, param, this.internalData);
    }

    @Override
    public VerifyCertificateResponse verifyCertificate(VerifyCertificate param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.VerifyCertificate);
        return (VerifyCertificateResponse)SALProtocolBaseImpl.perform(VerifyCertificateResponse.class, s, param, this.internalData);
    }

    @Override
    public DIDCreateResponse didCreate(DIDCreate param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.DIDCreate);
        return (DIDCreateResponse)SALProtocolBaseImpl.perform(DIDCreateResponse.class, s, param, this.internalData);
    }

    @Override
    public DIDUpdateResponse didUpdate(DIDUpdate param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.DIDUpdate);
        return (DIDUpdateResponse)SALProtocolBaseImpl.perform(DIDUpdateResponse.class, s, param, this.internalData);
    }

    @Override
    public DIDDeleteResponse didDelete(DIDDelete param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.DIDDelete);
        return (DIDDeleteResponse)SALProtocolBaseImpl.perform(DIDDeleteResponse.class, s, param, this.internalData);
    }

    @Override
    public DIDAuthenticateResponse didAuthenticate(DIDAuthenticate param) {
        ProtocolStep<? extends RequestType, ? extends ResponseType> s = this.next(FunctionType.DIDAuthenticate);
        return (DIDAuthenticateResponse)SALProtocolBaseImpl.perform(DIDAuthenticateResponse.class, s, param, this.internalData);
    }

    @Override
    public boolean needsSM() {
        return false;
    }

    @Override
    public byte[] applySM(byte[] commandAPDU) {
        return commandAPDU;
    }

    @Override
    public byte[] removeSM(byte[] responseAPDU) {
        return responseAPDU;
    }
}

