/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.openecard.addon.manifest.Configuration;
import org.openecard.addon.manifest.LocalizedString;

@XmlRootElement(name="AppExtensionSpecification")
@XmlType(propOrder={"id", "className", "localizedName", "localizedDescription", "configDescription"})
public class AppExtensionSpecification {
    private String id;
    private String className;
    private final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    private final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();
    private Configuration configDescription;

    @XmlElement(name="ID")
    public String getId() {
        return this.id;
    }

    @XmlElement(name="ClassName")
    public String getClassName() {
        return this.className;
    }

    @XmlElement(name="LocalizedName")
    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    @XmlElement(name="LocalizedDescription")
    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    @XmlElement(name="ConfigDescription")
    public Configuration getConfigDescription() {
        return this.configDescription;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setConfigDescription(Configuration configDescription) {
        this.configDescription = configDescription;
    }

    public String getLocalizedName(String languageCode) {
        String fallback = "No localized Name found.";
        for (LocalizedString s : this.localizedName) {
            if (s.getLang().equalsIgnoreCase(languageCode)) {
                return s.getValue();
            }
            if (!s.getLang().equalsIgnoreCase("EN")) continue;
            fallback = s.getValue();
        }
        return fallback;
    }

    public String getLocalizedDescription(String languageCode) {
        String fallback = "No localized Description found.";
        for (LocalizedString s : this.localizedDescription) {
            if (s.getLang().equalsIgnoreCase(languageCode)) {
                return s.getValue();
            }
            if (!s.getLang().equalsIgnoreCase("EN")) continue;
            fallback = s.getValue();
        }
        return fallback;
    }
}

