/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.Configuration;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="AddonSpecification")
@XmlType(propOrder={"id", "version", "license", "localizedName", "localizedDescription", "about", "logo", "configDescription", "bindingActions", "applicationActions", "ifdActions", "salActions"})
public class AddonSpecification {
    private static final Logger logger = LoggerFactory.getLogger(AddonSpecification.class);
    private String id;
    private String logoFile;
    private byte[] logoBytes;
    private String version;
    private String license;
    private Configuration configDescription;
    private final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    private final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();
    private final List<LocalizedString> about = new ArrayList<LocalizedString>();
    private final ArrayList<AppExtensionSpecification> appExtensionActions = new ArrayList();
    private final ArrayList<AppPluginSpecification> appPluginActions = new ArrayList();
    private final ArrayList<ProtocolPluginSpecification> ifdActions = new ArrayList();
    private final ArrayList<ProtocolPluginSpecification> salActions = new ArrayList();

    @XmlElement(name="ID")
    public String getId() {
        return this.id;
    }

    @XmlElement(name="LocalizedName")
    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    public String getLocalizedName(String languageCode) {
        String fallback = "No localized Name found.";
        for (LocalizedString s : this.localizedName) {
            if (s.getLang().equalsIgnoreCase(languageCode)) {
                return s.getValue();
            }
            if (!s.getLang().equalsIgnoreCase("EN")) continue;
            fallback = s.getValue();
        }
        return fallback;
    }

    @XmlElement(name="LocalizedDescription")
    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    public String getLocalizedDescription(String languageCode) {
        String fallback = "No localized Description found.";
        for (LocalizedString s : this.localizedDescription) {
            if (s.getLang().equalsIgnoreCase(languageCode)) {
                return s.getValue();
            }
            if (!s.getLang().equalsIgnoreCase("EN")) continue;
            fallback = s.getValue();
        }
        return fallback;
    }

    @XmlElement(name="Logo")
    public String getLogo() {
        return this.logoFile;
    }

    @XmlElement(name="Version")
    public String getVersion() {
        return this.version;
    }

    @XmlElement(name="About")
    public List<LocalizedString> getAbout() {
        return this.about;
    }

    public String getAbout(String languageCode) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @XmlElement(name="License")
    public String getLicense() {
        return this.license;
    }

    @XmlElementWrapper(name="BindingActions")
    @XmlElement(name="AppPluginSpecification")
    public ArrayList<AppPluginSpecification> getBindingActions() {
        return this.appPluginActions;
    }

    @XmlElementWrapper(name="IFDActions")
    @XmlElement(name="ProtocolPluginSpecification")
    public ArrayList<ProtocolPluginSpecification> getIfdActions() {
        return this.ifdActions;
    }

    @XmlElementWrapper(name="ApplicationActions")
    @XmlElement(name="AppExtensionSpecification")
    public ArrayList<AppExtensionSpecification> getApplicationActions() {
        return this.appExtensionActions;
    }

    @XmlElementWrapper(name="SALActions")
    @XmlElement(name="ProtocolPluginSpecification")
    public ArrayList<ProtocolPluginSpecification> getSalActions() {
        return this.salActions;
    }

    @XmlElement(name="ConfigDescription")
    public Configuration getConfigDescription() {
        return this.configDescription;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogo(String logo) {
        this.logoFile = logo;
        logger.debug("LogoFile: " + this.logoFile);
        if (this.logoFile != null && !this.logoFile.isEmpty()) {
            try {
                InputStream logoStream = FileUtils.resolveResourceAsStream(AddonSpecification.class, this.logoFile);
                this.logoBytes = FileUtils.toByteArray(logoStream);
            }
            catch (FileNotFoundException e) {
                logger.error("Logo file couldn't be found.", e);
            }
            catch (IOException e) {
                logger.error("Logo file couldn't be read.", e);
            }
            catch (NullPointerException e) {
                logger.error("Logo file couldn't be read.", e);
            }
        }
    }

    public byte[] getLogoBytes() {
        return this.logoBytes;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setConfigDescription(Configuration configDescription) {
        this.configDescription = configDescription;
    }

    public AppPluginSpecification searchByResourceName(String resourceName) {
        for (AppPluginSpecification desc : this.appPluginActions) {
            if (!resourceName.equals(desc.getResourceName())) continue;
            return desc;
        }
        return null;
    }

    public AppExtensionSpecification searchByActionId(String id) {
        for (AppExtensionSpecification desc : this.appExtensionActions) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public ProtocolPluginSpecification searchIFDActionByURI(String uri) {
        for (ProtocolPluginSpecification desc : this.ifdActions) {
            if (!desc.getUri().equals(uri)) continue;
            return desc;
        }
        return null;
    }

    public ProtocolPluginSpecification searchSALActionByURI(String uri) {
        for (ProtocolPluginSpecification desc : this.salActions) {
            if (!desc.getUri().equals(uri)) continue;
            return desc;
        }
        return null;
    }
}

