/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import javax.annotation.Nonnull;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.CombiningRegistry;
import org.openecard.addon.Context;
import org.openecard.addon.EventHandler;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.addon.bind.AppExtensionActionProxy;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.AppPluginActionProxy;
import org.openecard.addon.ifd.IFDProtocol;
import org.openecard.addon.ifd.IFDProtocolProxy;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.addon.sal.SALProtocol;
import org.openecard.addon.sal.SALProtocolProxy;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.EventManager;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.gui.UserConsent;
import org.openecard.recognition.CardRecognition;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonManager {
    private static final Logger logger = LoggerFactory.getLogger(AddonManager.class);
    private final AddonRegistry registry = new CombiningRegistry();
    private final Dispatcher dispatcher;
    private final UserConsent userConsent;
    private final CardStateMap cardStates;
    private final CardRecognition recognition;
    private final EventManager eventManager;
    private final EventHandler eventHandler;

    public AddonManager(Dispatcher dispatcher, UserConsent userConsent, CardStateMap cardStates, CardRecognition recognition, EventManager eventManager) throws WSMarshallerException {
        this.dispatcher = dispatcher;
        this.userConsent = userConsent;
        this.cardStates = cardStates;
        this.recognition = recognition;
        this.eventManager = eventManager;
        this.eventHandler = new EventHandler(eventManager);
    }

    public AddonRegistry getRegistry() {
        return this.registry;
    }

    public IFDProtocol getIFDProtocol(@Nonnull AddonSpecification addonSpec, @Nonnull String uri) {
        ProtocolPluginSpecification protoSpec = addonSpec.searchIFDActionByURI(uri);
        String className = protoSpec.getClassName();
        ClassLoader cl = this.registry.downloadPlugin(addonSpec);
        IFDProtocolProxy protoFactory = new IFDProtocolProxy(className, cl);
        try {
            Context aCtx = new Context(this, this.dispatcher, this.userConsent, this.cardStates, this.recognition, this.eventManager, this.eventHandler);
            protoFactory.init(aCtx);
            return protoFactory;
        }
        catch (ActionInitializationException e) {
            logger.error("Initialization of IFD Protocol failed", e);
            return null;
        }
    }

    public SALProtocol getSALProtocol(@Nonnull AddonSpecification addonSpec, @Nonnull String uri) {
        ProtocolPluginSpecification protoSpec = addonSpec.searchSALActionByURI(uri);
        String className = protoSpec.getClassName();
        ClassLoader cl = this.registry.downloadPlugin(addonSpec);
        SALProtocolProxy protoFactory = new SALProtocolProxy(className, cl);
        try {
            Context aCtx = new Context(this, this.dispatcher, this.userConsent, this.cardStates, this.recognition, this.eventManager, this.eventHandler);
            protoFactory.init(aCtx);
            return protoFactory;
        }
        catch (ActionInitializationException e) {
            logger.error("Initialization of SAL Protocol failed", e);
            return null;
        }
    }

    public AppExtensionAction getAppExtensionAction(@Nonnull AddonSpecification addonSpec, @Nonnull String actionId) {
        AppExtensionSpecification protoSpec = addonSpec.searchByActionId(actionId);
        String className = protoSpec.getClassName();
        ClassLoader cl = this.registry.downloadPlugin(addonSpec);
        AppExtensionActionProxy protoFactory = new AppExtensionActionProxy(className, cl);
        try {
            Context aCtx = new Context(this, this.dispatcher, this.userConsent, this.cardStates, this.recognition, this.eventManager, this.eventHandler);
            protoFactory.init(aCtx);
            return protoFactory;
        }
        catch (ActionInitializationException e) {
            logger.error("Initialization of AppExtensionAction failed", e);
            return null;
        }
    }

    public AppPluginAction getAppPluginAction(@Nonnull AddonSpecification addonSpec, @Nonnull String resourceName) {
        AppPluginSpecification protoSpec = addonSpec.searchByResourceName(resourceName);
        String className = protoSpec.getClassName();
        ClassLoader cl = this.registry.downloadPlugin(addonSpec);
        AppPluginActionProxy protoFactory = new AppPluginActionProxy(className, cl);
        try {
            Context aCtx = new Context(this, this.dispatcher, this.userConsent, this.cardStates, this.recognition, this.eventManager, this.eventHandler);
            protoFactory.init(aCtx);
            return protoFactory;
        }
        catch (ActionInitializationException e) {
            logger.error("Initialization of AppPluginAction failed", e);
            return null;
        }
    }
}

