/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.dispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.openecard.common.interfaces.DispatcherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Service {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private final Class iface;
    private final ArrayList<Class> requestClasses;
    private final TreeMap<String, Method> requestMethods;

    public Service(Class iface) {
        Method[] methods;
        this.iface = iface;
        this.requestClasses = new ArrayList();
        this.requestMethods = new TreeMap();
        for (Method m : methods = iface.getDeclaredMethods()) {
            if (!this.isReqParam(m)) continue;
            Class reqClass = this.getReqParamClass(m);
            if (this.requestMethods.containsKey(reqClass.getName())) {
                String msg = "Omitting method {} in service interface {}, because its parameter type is already ";
                msg = msg + "associated with another method.";
                logger.warn(msg, (Object)m.getName(), (Object)iface.getName());
                continue;
            }
            this.requestClasses.add(reqClass);
            this.requestMethods.put(reqClass.getName(), m);
        }
    }

    public Class getServiceInterface() {
        return this.iface;
    }

    public Object invoke(Object ifaceImpl, Object req) throws DispatcherException, InvocationTargetException {
        try {
            Class<?> reqClass = req.getClass();
            Method m = this.getMethod(reqClass.getName());
            return m.invoke(ifaceImpl, req);
        }
        catch (IllegalAccessException ex) {
            throw new DispatcherException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new DispatcherException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new DispatcherException(ex);
        }
    }

    private Class getReqParamClass(Method m) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length != 1) {
            return null;
        }
        return params[0];
    }

    private boolean isReqParam(Method m) {
        return this.getReqParamClass(m) != null;
    }

    public List<Class> getRequestClasses() {
        return Collections.unmodifiableList(this.requestClasses);
    }

    private Method getMethod(String paramClass) throws NoSuchMethodException {
        Method m = this.requestMethods.get(paramClass);
        if (m == null) {
            String msg = "Method containing parameter with class '" + paramClass + "' does not exist in interface '";
            msg = msg + this.iface.getName() + "'.";
            throw new NoSuchMethodException(msg);
        }
        return m;
    }
}

