/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.io.SignerInputStream;
import org.openecard.bouncycastle.crypto.params.ECDomainParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.CombinedHash;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsECCUtils;
import org.openecard.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsSigner;
import org.openecard.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, int[] namedCurves, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms, namedCurves, clientECPointFormats, serverECPointFormats);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        int namedCurve = -1;
        if (this.namedCurves == null) {
            namedCurve = 23;
        } else {
            for (int i = 0; i < this.namedCurves.length; ++i) {
                int entry = this.namedCurves[i];
                if (!TlsECCUtils.isSupportedNamedCurve(entry)) continue;
                namedCurve = entry;
                break;
            }
        }
        ECDomainParameters curve_params = null;
        if (namedCurve >= 0) {
            curve_params = TlsECCUtils.getParametersForNamedCurve(namedCurve);
        } else if (TlsProtocol.arrayContains(this.namedCurves, 65281)) {
            curve_params = TlsECCUtils.getParametersForNamedCurve(23);
        } else if (TlsProtocol.arrayContains(this.namedCurves, 65282)) {
            curve_params = TlsECCUtils.getParametersForNamedCurve(7);
        }
        if (curve_params == null) {
            throw new TlsFatalAlert(80);
        }
        AsymmetricCipherKeyPair kp = TlsECCUtils.generateECKeyPair(this.context.getSecureRandom(), curve_params);
        this.ecAgreeServerPrivateKey = (ECPrivateKeyParameters)kp.getPrivate();
        byte[] publicBytes = TlsECCUtils.serializeECPublicKey(this.clientECPointFormats, (ECPublicKeyParameters)kp.getPublic());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (namedCurve < 0) {
            TlsECCUtils.writeExplicitECParameters(this.clientECPointFormats, curve_params, buf);
        } else {
            TlsECCUtils.writeNamedECParameters(namedCurve, buf);
        }
        TlsUtils.writeOpaque8(publicBytes, buf);
        byte[] digestInput = buf.toByteArray();
        CombinedHash d = new CombinedHash();
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        d.update(digestInput, 0, digestInput.length);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] sigBytes = this.serverCredentials.generateCertificateSignature(hash);
        TlsUtils.writeOpaque16(sigBytes, buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initVerifyer(this.tlsSigner, securityParameters);
        SignerInputStream sigIn = new SignerInputStream(input, signer);
        ECDomainParameters curve_params = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, sigIn);
        byte[] point = TlsUtils.readOpaque8(sigIn);
        byte[] sigByte = TlsUtils.readOpaque16(input);
        if (!signer.verifySignature(sigByte)) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreeServerPublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, curve_params, point));
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

