/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openecard.bouncycastle.crypto.prng.ThreadedSeedGenerator;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsContext;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.NewSessionTicket;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.TlsAuthentication;
import org.openecard.bouncycastle.crypto.tls.TlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsClientContextImpl;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsPeer;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    protected TlsClientContextImpl tlsClientContext = null;
    protected int[] offeredCipherSuites = null;
    protected short[] offeredCompressionMethods = null;
    protected Hashtable clientExtensions = null;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateRequest certificateRequest = null;

    private static SecureRandom createSecureRandom() {
        ThreadedSeedGenerator tsg = new ThreadedSeedGenerator();
        SecureRandom random = new SecureRandom();
        random.setSeed(tsg.generateSeed(20, true));
        return random;
    }

    public TlsClientProtocol(InputStream input, OutputStream output) {
        this(input, output, TlsClientProtocol.createSecureRandom());
    }

    public TlsClientProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        super(input, output, secureRandom);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null && !this.tlsClient.equals(tlsClient)) {
            throw new IllegalStateException("connect can only be called once");
        }
        this.tlsClient = tlsClient;
        this.securityParameters = tlsClient.getClientContext() == null ? new SecurityParameters() : tlsClient.getClientContext().getSecurityParameters();
        this.securityParameters.entity = 1;
        this.securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(this.secureRandom);
        this.tlsClientContext = new TlsClientContextImpl(this.secureRandom, this.securityParameters);
        this.tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        this.sendClientHelloMessage();
        this.connection_state = 1;
        this.completeHandshake();
        this.tlsClient.notifyHandshakeComplete();
    }

    @Override
    protected AbstractTlsContext getContext() {
        return this.tlsClientContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    @Override
    protected void handleChangeCipherSpecMessage() throws IOException {
        switch (this.connection_state) {
            case 13: {
                if (this.expectSessionTicket) {
                    this.failWithError((short)2, (short)40);
                }
            }
            case 14: {
                this.connection_state = (short)15;
                break;
            }
            default: {
                this.failWithError((short)2, (short)40);
            }
        }
    }

    @Override
    protected void handleHandshakeMessage(short type, byte[] data) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(data);
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        Certificate serverCertificate = Certificate.parse(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.keyExchange.processServerCertificate(serverCertificate);
                        this.authentication = this.tlsClient.getAuthentication();
                        this.authentication.notifyServerCertificate(serverCertificate);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 20: {
                switch (this.connection_state) {
                    case 15: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(buf);
                        this.connection_state = (short)2;
                        this.securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.selectedCipherSuite);
                        this.securityParameters.compressionAlgorithm = this.selectedCompressionMethod;
                        this.securityParameters.verifyDataLength = 12;
                        this.recordStream.notifyHelloComplete();
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 5: 
                    case 6: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)7;
                        Vector clientSupplementalData = this.tlsClient.getClientSupplementalData();
                        if (clientSupplementalData != null) {
                            this.sendSupplementalDataMessage(clientSupplementalData);
                        }
                        this.connection_state = (short)8;
                        TlsCredentials clientCreds = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            clientCreds = this.authentication.getClientCredentials(this.certificateRequest);
                            if (clientCreds == null) {
                                this.keyExchange.skipClientCredentials();
                                this.sendCertificateMessage(Certificate.EMPTY_CHAIN);
                            } else {
                                this.keyExchange.processClientCredentials(clientCreds);
                                this.sendCertificateMessage(clientCreds.getCertificate());
                            }
                        }
                        this.connection_state = (short)9;
                        this.sendClientKeyExchangeMessage();
                        TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        this.recordStream.setPendingConnectionState(this.tlsClient.getCompression(), this.tlsClient.getCipher());
                        this.connection_state = (short)10;
                        if (clientCreds != null && clientCreds instanceof TlsSignerCredentials) {
                            TlsSignerCredentials signerCreds = (TlsSignerCredentials)clientCreds;
                            byte[] md5andsha1 = this.recordStream.getCurrentHash(null);
                            byte[] clientCertificateSignature = signerCreds.generateCertificateSignature(md5andsha1);
                            this.sendCertificateVerifyMessage(clientCertificateSignature);
                            this.connection_state = (short)11;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.connection_state = (short)12;
                        this.sendFinishedMessage();
                        this.connection_state = (short)13;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)40);
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: {
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)5;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 5: {
                        if (this.authentication == null) {
                            this.failWithError((short)2, (short)40);
                        }
                        this.certificateRequest = CertificateRequest.parse(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.keyExchange.validateCertificateRequest(this.certificateRequest);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            this.failWithError((short)2, (short)10);
                        }
                        this.receiveNewSessionTicketMessage(buf);
                        this.connection_state = (short)14;
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (this.connection_state != 16) break;
                this.secure_renegotiation = true;
                this.connect(this.tlsClient);
                break;
            }
            default: {
                this.failWithError((short)2, (short)10);
            }
        }
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)3;
        this.keyExchange = this.tlsClient.getKeyExchange();
        this.keyExchange.init(this.getContext());
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        ProtocolVersion client_version;
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        if (server_version.isDTLS()) {
            this.failWithError((short)2, (short)47);
        }
        if (!server_version.equals(this.recordStream.getReadVersion())) {
            this.failWithError((short)2, (short)47);
        }
        if (!server_version.isEqualOrEarlierVersionOf(client_version = this.getContext().getClientVersion())) {
            this.failWithError((short)2, (short)47);
        }
        this.recordStream.setWriteVersion(server_version);
        this.getContext().setServerVersion(server_version);
        this.tlsClient.notifyServerVersion(server_version);
        this.securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)buf);
        byte[] sessionID = TlsUtils.readOpaque8(buf);
        if (sessionID.length > 32) {
            this.failWithError((short)2, (short)47);
        }
        if (sessionID.length > 0 && Arrays.areEqual(sessionID, this.tlsClient.getSessionID())) {
            this.resumed = true;
        }
        this.tlsClient.notifySessionID(sessionID);
        this.selectedCipherSuite = TlsUtils.readUint16(buf);
        if (!TlsClientProtocol.arrayContains(this.offeredCipherSuites, this.selectedCipherSuite) || this.selectedCipherSuite == 0 || this.selectedCipherSuite == 255) {
            this.failWithError((short)2, (short)47);
        }
        this.tlsClient.notifySelectedCipherSuite(this.selectedCipherSuite);
        short selectedCompressionMethod = TlsUtils.readUint8(buf);
        if (!TlsClientProtocol.arrayContains(this.offeredCompressionMethods, selectedCompressionMethod)) {
            this.failWithError((short)2, (short)47);
        }
        this.tlsClient.notifySelectedCompressionMethod(selectedCompressionMethod);
        Hashtable serverExtensions = TlsClientProtocol.readExtensions(buf);
        if (serverExtensions != null) {
            Enumeration e = serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(EXT_RenegotiationInfo) || this.clientExtensions != null && this.clientExtensions.get(extType) != null) continue;
                this.failWithError((short)2, (short)110);
            }
            byte[] renegExtValue = (byte[])serverExtensions.get(EXT_RenegotiationInfo);
            if (renegExtValue != null) {
                if (!this.secure_renegotiation) {
                    if (!Arrays.constantTimeAreEqual(renegExtValue, TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                        this.failWithError((short)2, (short)40);
                    }
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    bos.write(this.client_verify_data);
                    bos.write(this.server_verify_data);
                    if (!Arrays.constantTimeAreEqual(renegExtValue, TlsClientProtocol.createRenegotiationInfo(bos.toByteArray()))) {
                        this.failWithError((short)2, (short)40);
                    }
                }
            } else if (this.secure_renegotiation) {
                this.failWithError((short)2, (short)40);
            }
            this.expectSessionTicket = serverExtensions.containsKey(EXT_SessionTicket);
        }
        this.tlsClient.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            this.tlsClient.processServerExtensions(serverExtensions);
        }
    }

    protected void sendCertificateVerifyMessage(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)15, bos);
        TlsUtils.writeUint24(data.length + 2, bos);
        TlsUtils.writeOpaque16(data, bos);
        byte[] message = bos.toByteArray();
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendClientHelloMessage() throws IOException {
        this.recordStream.setWriteVersion(this.tlsClient.getClientHelloRecordLayerVersion());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, buf);
        TlsUtils.writeUint24(0, buf);
        ProtocolVersion client_version = this.tlsClient.getClientVersion();
        if (client_version.isDTLS()) {
            this.failWithError((short)2, (short)80);
        }
        this.getContext().setClientVersion(client_version);
        TlsUtils.writeVersion(client_version, buf);
        buf.write(this.securityParameters.clientRandom);
        if (this.tlsClient.getSessionID() == null) {
            TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, buf);
        } else {
            TlsUtils.writeUint8((short)this.tlsClient.getSessionID().length, buf);
            buf.write(this.tlsClient.getSessionID());
        }
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.clientExtensions = this.tlsClient.getClientExtensions();
        if (this.secure_renegotiation) {
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(this.client_verify_data));
        }
        boolean noRenegExt = this.clientExtensions == null || this.clientExtensions.get(EXT_RenegotiationInfo) == null;
        int count = this.offeredCipherSuites.length;
        if (noRenegExt) {
            ++count;
        }
        TlsUtils.writeUint16(2 * count, buf);
        TlsUtils.writeUint16Array(this.offeredCipherSuites, buf);
        if (noRenegExt) {
            TlsUtils.writeUint16(255, buf);
        }
        this.offeredCompressionMethods = this.tlsClient.getCompressionMethods();
        TlsUtils.writeUint8((short)this.offeredCompressionMethods.length, buf);
        TlsUtils.writeUint8Array(this.offeredCompressionMethods, buf);
        if (this.clientExtensions != null) {
            TlsClientProtocol.writeExtensions(buf, this.clientExtensions);
        }
        byte[] message = buf.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)16, bos);
        TlsUtils.writeUint24(0, bos);
        this.keyExchange.generateClientKeyExchange(bos);
        byte[] message = bos.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    @Override
    protected void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] b = new byte[1];
            this.changeCipherSpecQueue.read(b, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (b[0] != 1) {
                this.failWithError((short)2, (short)10);
            }
            if (this.resumed) {
                this.recordStream.setPendingConnectionState(this.tlsClient.getCompression(), this.tlsClient.getCipher());
                this.sendChangeCipherSpecMessage();
                this.connection_state = (short)14;
            }
            this.recordStream.receivedReadCipherSpec();
            this.handleChangeCipherSpecMessage();
        }
    }
}

