/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.httpcore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openecard.apache.http.impl.AbstractHttpClientConnection;
import org.openecard.apache.http.params.HttpParams;
import org.openecard.transport.httpcore.OECBasicHttpParams;
import org.openecard.transport.httpcore.StreamSessionInputBuffer;
import org.openecard.transport.httpcore.StreamSessionOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamHttpClientConnection
extends AbstractHttpClientConnection {
    private static final Logger logger = LoggerFactory.getLogger(StreamHttpClientConnection.class);
    private static final int BUFSIZE = 4096;
    private final InputStream in;
    private final OutputStream out;
    private final HttpParams params;
    private boolean open = true;

    public StreamHttpClientConnection(InputStream in, OutputStream out) {
        this(in, out, new OECBasicHttpParams());
    }

    public StreamHttpClientConnection(InputStream in, OutputStream out, HttpParams params) {
        this.in = in;
        this.out = out;
        this.params = params;
        StreamSessionInputBuffer sin = new StreamSessionInputBuffer(in, 4096, params);
        StreamSessionOutputBuffer sout = new StreamSessionOutputBuffer(out, 4096, params);
        this.init(sin, sout, params);
    }

    public HttpParams getParams() {
        return this.params;
    }

    @Override
    protected void assertOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Underlying channel of HTTP connection is not open.");
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void shutdown() throws IOException {
        this.open = false;
        this.in.close();
        this.out.close();
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.doFlush();
            try {
                this.in.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSocketTimeout(int timeout) {
        logger.info("Not supported in this type of connection.");
    }

    @Override
    public int getSocketTimeout() {
        return 0;
    }
}

