/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.util.Promise;
import org.openecard.common.util.TR03112Utils;
import org.openecard.control.ControlException;
import org.openecard.control.module.tctoken.CertificateVerifier;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectCertificateVerifier
implements CertificateVerifier {
    private static final Logger logger = LoggerFactory.getLogger(RedirectCertificateVerifier.class);
    private final I18n lang = I18n.getTranslation("tctoken");
    private final Promise<Object> descPromise;
    private final boolean redirectChecks;

    public RedirectCertificateVerifier(boolean redirectChecks) {
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        this.descPromise = dynCtx.getPromise("eservice_certificate_description");
        this.redirectChecks = redirectChecks;
    }

    @Override
    public CertificateVerifier.VerifierResult verify(URL url, Certificate cert) {
        try {
            if (this.redirectChecks) {
                CertificateDescription desc = null;
                try {
                    desc = (CertificateDescription)this.descPromise.deref(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    String msg = "Couldn't retrieve the CertificateDescription from the DynamicContext.";
                    logger.error(msg);
                    throw new ControlException(msg);
                }
                catch (TimeoutException ex) {
                    String msg = "Couldn't retrieve the CertificateDescription from the DynamicContext.";
                    logger.error(msg);
                    throw new ControlException(msg);
                }
                if (!TR03112Utils.isInCommCertificates(cert, desc.getCommCertificates())) {
                    logger.error("The retrieved server certificate is NOT contained in the CommCertificates of the CertificateDescription extension of the eService certificate.");
                    throw new ControlException(this.lang.translationForKey("invalid_redirect", new Object[0]));
                }
                URL subjectUrl = new URL(desc.getSubjectURL());
                boolean SOP = TR03112Utils.checkSameOriginPolicy(url, subjectUrl);
                if (!SOP) {
                    return CertificateVerifier.VerifierResult.CONTINE;
                }
                return CertificateVerifier.VerifierResult.FINISH;
            }
            return CertificateVerifier.VerifierResult.FINISH;
        }
        catch (MalformedURLException ex) {
            throw new ControlException("Failed to convert SubjectURL to URL class.", ex);
        }
    }
}

