/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin;

import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.SlotCapabilityType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.util.InsertCardDialog;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;
import org.openecard.gui.UserConsent;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.recognition.CardRecognition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPINAction
implements AppExtensionAction {
    protected final I18n lang = I18n.getTranslation("pinplugin");
    private static final Logger logger = LoggerFactory.getLogger(AbstractPINAction.class);
    protected static final String GERMAN_IDENTITY_CARD = "http://bsi.bund.de/cif/npa.xml";
    private static final byte[] recognizeCommandAPDU = StringUtils.toByteArray("0022C1A40F800A04007F00070202040202830103");
    private static final byte[] RESPONSE_RC3 = new byte[]{-112, 0};
    private static final byte[] RESPONSE_BLOCKED = new byte[]{99, -64};
    private static final byte[] RESPONSE_SUSPENDED = new byte[]{99, -63};
    private static final byte[] RESPONSE_RC2 = new byte[]{99, -62};
    private static final byte[] RESPONSE_DEACTIVATED = new byte[]{98, -125};
    protected Dispatcher dispatcher;
    protected UserConsent gui;
    protected CardRecognition recognition;
    protected CardStateMap cardStates;

    protected RecognizedState recognizeState(ConnectionHandleType cHandle) throws InvocationTargetException, DispatcherException {
        RecognizedState state;
        Transmit t = new Transmit();
        t.setSlotHandle(cHandle.getSlotHandle());
        InputAPDUInfoType inputAPDU = new InputAPDUInfoType();
        inputAPDU.setInputAPDU(recognizeCommandAPDU);
        t.getInputAPDUInfo().add(inputAPDU);
        TransmitResponse response = (TransmitResponse)this.dispatcher.deliver(t);
        byte[] responseAPDU = response.getOutputAPDU().get(0);
        if (ByteUtils.compare(RESPONSE_RC3, responseAPDU)) {
            state = RecognizedState.PIN_activated_RC3;
        } else if (ByteUtils.compare(RESPONSE_DEACTIVATED, responseAPDU)) {
            state = RecognizedState.PIN_deactivated;
        } else if (ByteUtils.compare(RESPONSE_RC2, responseAPDU)) {
            state = RecognizedState.PIN_activated_RC2;
        } else if (ByteUtils.compare(RESPONSE_SUSPENDED, responseAPDU)) {
            state = RecognizedState.PIN_suspended;
        } else if (ByteUtils.compare(RESPONSE_BLOCKED, responseAPDU)) {
            state = RecognizedState.PIN_blocked;
        } else {
            logger.error("Unhandled response to the PIN state recognition APDU: {}\n");
            state = RecognizedState.UNKNOWN;
        }
        logger.info("State of the PIN: {}.", (Object)state);
        return state;
    }

    protected ConnectionHandleType waitForCardType(String cardType) {
        String cardName = this.recognition.getTranslatedCardName(cardType);
        InsertCardDialog uc = new InsertCardDialog(this.gui, this.cardStates, cardType, cardName);
        return uc.show();
    }

    protected ConnectionHandleType connectToRootApplication(ConnectionHandleType cHandle) throws InvocationTargetException, DispatcherException {
        CardApplicationPath cardApplicationPath = new CardApplicationPath();
        cardApplicationPath.setCardAppPathRequest(cHandle);
        CardApplicationPathResponse cardApplicationPathResponse = (CardApplicationPathResponse)this.dispatcher.deliver(cardApplicationPath);
        try {
            WSHelper.checkResult(cardApplicationPathResponse);
        }
        catch (WSHelper.WSException ex) {
            logger.error("CardApplicationPath failed.", ex);
            return null;
        }
        CardApplicationConnect cardApplicationConnect = new CardApplicationConnect();
        cardApplicationConnect.setCardApplicationPath(cardApplicationPathResponse.getCardAppPathResultSet().getCardApplicationPathResult().get(0));
        CardApplicationConnectResponse cardApplicationConnectResponse = (CardApplicationConnectResponse)this.dispatcher.deliver(cardApplicationConnect);
        try {
            WSHelper.checkResult(cardApplicationConnectResponse);
        }
        catch (WSHelper.WSException ex) {
            logger.error("CardApplicationConnect failed.", ex);
            return null;
        }
        cHandle = cardApplicationConnectResponse.getConnectionHandle();
        return cHandle;
    }

    protected boolean genericPACESupport(ConnectionHandleType connectionHandle) throws InvocationTargetException, DispatcherException, WSHelper.WSException {
        GetIFDCapabilities capabilitiesRequest = new GetIFDCapabilities();
        capabilitiesRequest.setContextHandle(connectionHandle.getContextHandle());
        capabilitiesRequest.setIFDName(connectionHandle.getIFDName());
        GetIFDCapabilitiesResponse capabilitiesResponse = (GetIFDCapabilitiesResponse)this.dispatcher.deliver(capabilitiesRequest);
        WSHelper.checkResult(capabilitiesResponse);
        if (capabilitiesResponse.getIFDCapabilities() != null) {
            List<SlotCapabilityType> capabilities = capabilitiesResponse.getIFDCapabilities().getSlotCapability();
            String genericPACE = PACECapabilities.PACECapability.GenericPACE.getProtocol();
            for (SlotCapabilityType capability : capabilities) {
                if (!capability.getIndex().equals(connectionHandle.getSlotIndex())) continue;
                for (String protocol : capability.getProtocol()) {
                    if (!protocol.equals(genericPACE)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

