/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import java.util.Arrays;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.IntegerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutePACEResponse {
    private static final Logger logger = LoggerFactory.getLogger(ExecutePACEResponse.class);
    final int result;
    final short length;
    final byte[] data;

    public ExecutePACEResponse(byte[] response) {
        this.result = ByteUtils.toInteger(Arrays.copyOfRange(response, 0, 4), false);
        this.length = ByteUtils.toShort(Arrays.copyOfRange(response, 4, 6), false);
        this.data = Arrays.copyOfRange(response, 6, 6 + this.length);
    }

    public boolean isError() {
        return this.result != 0;
    }

    public int getResultCode() {
        return this.result;
    }

    public Result getResult() {
        switch (this.result) {
            case 0: {
                return WSHelper.makeResultOK();
            }
            case -805306367: {
                return WSHelper.makeResultUnknownError("Inconsistent lengths in input.");
            }
            case -805306366: {
                return WSHelper.makeResultUnknownError("Unexpected data in input.");
            }
            case -805306365: {
                return WSHelper.makeResultUnknownError("Unexpected combination of data in input.");
            }
            case -536870911: {
                return WSHelper.makeResultUnknownError("Syntax error in TLV response.");
            }
            case -536870910: {
                return WSHelper.makeResultUnknownError("Unexpected or missing object in TLV response.");
            }
            case -536870909: {
                return WSHelper.makeResultUnknownError("Unknown PIN-ID.");
            }
            case -536870906: {
                return WSHelper.makeResultUnknownError("Wrong Authentication Token.");
            }
            case -267386879: {
                return WSHelper.makeResultUnknownError("Communication abort.");
            }
            case -267386878: {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#noCard", "No card.");
            }
            case -266338303: {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", "Abort.");
            }
            case -266338302: {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError", "Timeout.");
            }
        }
        if ((this.result & 0xFFFC0000) == -268435456) {
            byte[] sw = new byte[]{(byte)(this.result >> 8 & 0xFF), (byte)(this.result & 0xFF)};
            String msg = CardCommandStatus.getMessage(sw);
            int type = this.result >> 16 & 0xFFFF;
            switch (type) {
                case 61440: {
                    return WSHelper.makeResultUnknownError("Select EF.CardAccess: " + msg);
                }
                case 61441: {
                    return WSHelper.makeResultUnknownError("Read Binary EF.CardAccess: " + msg);
                }
                case 61442: {
                    return WSHelper.makeResultUnknownError("MSE Set AT: " + msg);
                }
                case 61443: {
                    return WSHelper.makeResultUnknownError("General Authenticat Step 1-4: " + msg);
                }
            }
        }
        String hexStringResult = ByteUtils.toHexString(IntegerUtils.toByteArray(this.result));
        logger.warn("Unknown error in ExecutePACEResponse: {}", (Object)hexStringResult);
        return WSHelper.makeResultUnknownError(null);
    }

    public byte[] getData() {
        return this.data;
    }
}

