/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.tls.PSKTlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsAuthentication;
import org.openecard.bouncycastle.crypto.tls.TlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsPSKIdentity;
import org.openecard.crypto.tls.ClientCertTlsClient;
import org.openecard.crypto.tls.auth.DynamicAuthentication;

public class ClientCertPSKTlsClient
extends PSKTlsClient
implements ClientCertTlsClient {
    private final String fqdn;
    private TlsAuthentication tlsAuth;

    public ClientCertPSKTlsClient(TlsPSKIdentity pskId, String fqdn) {
        super(pskId, fqdn);
        this.fqdn = fqdn;
    }

    public ClientCertPSKTlsClient(TlsCipherFactory tcf, TlsPSKIdentity pskId, String fqdn) {
        super(tcf, pskId, fqdn);
        this.fqdn = fqdn;
    }

    @Override
    public synchronized TlsAuthentication getAuthentication() throws IOException {
        if (this.tlsAuth == null) {
            DynamicAuthentication tlsAuthTmp = new DynamicAuthentication();
            tlsAuthTmp.setHostname(this.fqdn);
            this.tlsAuth = tlsAuthTmp;
        }
        return this.tlsAuth;
    }

    @Override
    public synchronized void setAuthentication(TlsAuthentication tlsAuth) {
        this.tlsAuth = tlsAuth;
    }
}

