/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.ActionNameType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationListResponse;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DIDQualifierType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.NamedDataServiceActionName;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.util.Pair;
import org.openecard.crypto.common.sal.CredentialNotFound;
import org.openecard.crypto.common.sal.CryptoMarkerType;
import org.openecard.crypto.common.sal.GenericCryptoSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCryptoSignerFinder {
    private static final Logger logger = LoggerFactory.getLogger(GenericCryptoSignerFinder.class);
    private static final String OID_PKCS_1 = "urn:oid:1.2.840.113549.1.1";
    private static final String OID_GENERIC_CRYPTO = "urn:oid:1.3.162.15480.3.0.25";
    private static final String COMPUTE_SIGNATURE = "Compute-signature";
    private final Dispatcher dispatcher;
    private final ConnectionHandleType handle;
    private boolean filterAlwaysReadable;

    public GenericCryptoSignerFinder(@Nonnull Dispatcher dispatcher, @Nonnull ConnectionHandleType handle, boolean filterAlwaysReadable) {
        this.filterAlwaysReadable = filterAlwaysReadable;
        this.dispatcher = dispatcher;
        this.handle = WSHelper.copyHandle(handle);
    }

    @Nonnull
    public GenericCryptoSigner findDid(@Nonnull String didName) throws CredentialNotFound {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public GenericCryptoSigner findDid(@Nonnull String didName, @Nullable String algorithmUri) throws CredentialNotFound {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public GenericCryptoSigner findFirstMatching(@Nonnull org.openecard.bouncycastle.asn1.x509.Certificate[] caChain) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public GenericCryptoSigner findFirstMatching(@Nonnull Certificate caChain) throws CredentialNotFound {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public GenericCryptoSigner findFirstMatching(@Nonnull java.security.cert.Certificate[] caChain) throws CredentialNotFound {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public GenericCryptoSigner findFirstMatching(@Nonnull CertificateRequest cr) throws CredentialNotFound {
        List<Pair<String, byte[]>> result = this.findDID(this.dispatcher, this.handle);
        if (result.isEmpty()) {
            throw new CredentialNotFound("No suitable DID found.");
        }
        Pair<String, byte[]> firstResult = result.get(0);
        this.handle.setCardApplication((byte[])firstResult.p2);
        return new GenericCryptoSigner(this.dispatcher, this.handle, (String)firstResult.p1);
    }

    private List<Pair<String, byte[]>> findDID(Dispatcher dispatcher, ConnectionHandleType handle) {
        ArrayList<Pair<String, byte[]>> result = new ArrayList<Pair<String, byte[]>>();
        handle = WSHelper.copyHandle(handle);
        try {
            CardApplicationList listReq = new CardApplicationList();
            handle.setCardApplication(null);
            listReq.setConnectionHandle(handle);
            CardApplicationListResponse listRes = (CardApplicationListResponse)dispatcher.deliver(listReq);
            WSHelper.checkResult(listRes);
            CardApplicationListResponse.CardApplicationNameList cardApplicationNameList = listRes.getCardApplicationNameList();
            List<byte[]> cardApplicationName = cardApplicationNameList.getCardApplicationName();
            for (byte[] appIdentifier : cardApplicationName) {
                handle.setCardApplication(appIdentifier);
                List<String> didNamesList = this.getSignatureCapableDIDs(dispatcher, handle);
                didNamesList = this.filterTLSCapableDIDs(dispatcher, handle, didNamesList);
                if (this.filterAlwaysReadable) {
                    didNamesList = this.filterAlwaysReadable(dispatcher, handle, didNamesList);
                }
                for (String didName : didNamesList) {
                    result.add(new Pair<String, byte[]>(didName, appIdentifier));
                }
            }
        }
        catch (InvocationTargetException e) {
            logger.error("Searching for DID failed", e);
        }
        catch (DispatcherException e) {
            logger.error("Searching for DID failed", e);
        }
        catch (WSHelper.WSException e) {
            logger.error("Searching for DID failed", e);
        }
        return result;
    }

    private List<String> filterTLSCapableDIDs(Dispatcher dispatcher, ConnectionHandleType handle, List<String> didNames) throws DispatcherException, InvocationTargetException {
        ArrayList<String> remainingDIDs = new ArrayList<String>();
        for (String didName : didNames) {
            DIDGet didGet = new DIDGet();
            didGet.setConnectionHandle(handle);
            didGet.setDIDName(didName);
            DIDGetResponse didGetResponse = (DIDGetResponse)dispatcher.deliver(didGet);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didGetResponse.getDIDStructure().getDIDMarker());
            String algorithm = cryptoMarker.getAlgorithmInfo().getAlgorithmIdentifier().getAlgorithm();
            if (algorithm.equals(OID_PKCS_1)) {
                logger.debug("{} is usable for TLS signatures.", (Object)didName);
                remainingDIDs.add(didName);
                continue;
            }
            logger.debug("{} is not usable for TLS signatures.", (Object)didName);
        }
        return remainingDIDs;
    }

    private List<String> filterAlwaysReadable(Dispatcher dispatcher, ConnectionHandleType handle, List<String> didNames) throws DispatcherException, InvocationTargetException, WSHelper.WSException {
        ArrayList<String> remainingDIDs = new ArrayList<String>();
        for (String didName : didNames) {
            DIDGet didGet = new DIDGet();
            didGet.setConnectionHandle(handle);
            didGet.setDIDName(didName);
            didGet.setDIDScope(DIDScopeType.LOCAL);
            DIDGetResponse didGetResponse = (DIDGetResponse)dispatcher.deliver(didGet);
            WSHelper.checkResult(didGetResponse);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didGetResponse.getDIDStructure().getDIDMarker());
            CertificateRefType certificateRef = cryptoMarker.getCertificateRef();
            String certDataSetName = certificateRef.getDataSetName();
            ACLList acllist = new ACLList();
            acllist.setConnectionHandle(handle);
            TargetNameType value = new TargetNameType();
            value.setDataSetName(certDataSetName);
            acllist.setTargetName(value);
            ACLListResponse aclListResponse = (ACLListResponse)dispatcher.deliver(acllist);
            WSHelper.checkResult(aclListResponse);
            for (AccessRuleType accessRule : aclListResponse.getTargetACL().getAccessRule()) {
                ActionNameType action;
                NamedDataServiceActionName namedDataServiceAction;
                if (!accessRule.getCardApplicationServiceName().equals("NamedDataService") || !(namedDataServiceAction = (action = accessRule.getAction()).getNamedDataServiceAction()).equals((Object)NamedDataServiceActionName.DSI_READ)) continue;
                if (accessRule.getSecurityCondition().isAlways().booleanValue()) {
                    logger.debug("Certificate is always readable.");
                    remainingDIDs.add(didName);
                    continue;
                }
                logger.debug("Certificate needs did authentication to be readable.");
            }
        }
        return remainingDIDs;
    }

    private List<String> getSignatureCapableDIDs(Dispatcher dispatcher, ConnectionHandleType handle) throws DispatcherException, InvocationTargetException, WSHelper.WSException {
        DIDList didList = new DIDList();
        didList.setConnectionHandle(handle);
        DIDQualifierType filter = new DIDQualifierType();
        filter.setApplicationFunction(COMPUTE_SIGNATURE);
        filter.setObjectIdentifier(OID_GENERIC_CRYPTO);
        filter.setApplicationIdentifier(handle.getCardApplication());
        didList.setFilter(filter);
        DIDListResponse didListResponse = (DIDListResponse)dispatcher.deliver(didList);
        WSHelper.checkResult(didListResponse);
        List<String> didNames = didListResponse.getDIDNameList().getDIDName();
        return didNames;
    }
}

