/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.keystore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.crypto.CryptoException;
import org.openecard.bouncycastle.crypto.digests.NullDigest;
import org.openecard.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.openecard.bouncycastle.crypto.engines.RSABlindedEngine;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.openecard.bouncycastle.crypto.signers.GenericSigner;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.crypto.common.sal.CredentialPermissionDenied;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreSigner {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreSigner.class);
    private byte[] rawCertData;
    private Map<String, java.security.cert.Certificate[]> javaCerts;
    private Certificate bcCert;
    private KeyStore keyStore;
    private char[] password;
    private String alias;
    private InputStream inputStream;

    public KeyStoreSigner(@Nonnull KeyStore keyStore, InputStream inputStream, char[] password, String alias) {
        this.keyStore = keyStore;
        this.password = password;
        this.alias = alias;
        this.inputStream = inputStream;
        this.javaCerts = new HashMap<String, java.security.cert.Certificate[]>();
    }

    public synchronized byte[] getCertificateChain() throws CredentialPermissionDenied, IOException {
        if (this.rawCertData == null) {
            try {
                this.keyStore.load(this.inputStream, this.password);
                java.security.cert.Certificate[] cert = this.keyStore.getCertificateChain(this.alias);
                this.rawCertData = cert[0].getEncoded();
            }
            catch (KeyStoreException e) {
                throw new IOException("Keystore is not initialized.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            catch (CertificateException e) {
                throw new IOException(e);
            }
        }
        return this.rawCertData;
    }

    public java.security.cert.Certificate[] getJavaSecCertificateChain() throws CredentialPermissionDenied, CertificateException, IOException, NoSuchAlgorithmException, KeyStoreException {
        return this.getJavaSecCertificateChain("X.509");
    }

    @Nonnull
    public java.security.cert.Certificate[] getJavaSecCertificateChain(@Nonnull String certType) throws CertificateException, CredentialPermissionDenied, IOException {
        if (!this.javaCerts.containsKey(certType)) {
            byte[] certs = this.getCertificateChain();
            CertificateFactory cf = CertificateFactory.getInstance(certType);
            Collection<? extends java.security.cert.Certificate> javaCert = cf.generateCertificates(new ByteArrayInputStream(certs));
            this.javaCerts.put(certType, javaCert.toArray(new java.security.cert.Certificate[javaCert.size()]));
        }
        return this.javaCerts.get(certType);
    }

    @Nonnull
    public Certificate getBCCertificateChain() throws CredentialPermissionDenied, CertificateException, IOException {
        if (this.bcCert == null) {
            byte[] certs = this.getCertificateChain();
            this.bcCert = this.convertToBCCertificate(certs);
        }
        return this.bcCert;
    }

    public byte[] sign(@Nonnull byte[] hash) throws SignatureException, CredentialPermissionDenied {
        try {
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(this.password);
            KeyStore.Entry entry = this.keyStore.getEntry(this.alias, param);
            if (entry == null) {
                throw new SignatureException("No key entry for the given alias found.");
            }
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)entry;
            PrivateKey myPrivateKey = pkEntry.getPrivateKey();
            RSAPrivateCrtKey privCrtKey = (RSAPrivateCrtKey)myPrivateKey;
            RSAPrivateCrtKeyParameters key = new RSAPrivateCrtKeyParameters(privCrtKey.getModulus(), privCrtKey.getPublicExponent(), privCrtKey.getPrivateExponent(), privCrtKey.getPrimeP(), privCrtKey.getPrimeQ(), privCrtKey.getPrimeExponentP(), privCrtKey.getPrimeExponentQ(), privCrtKey.getCrtCoefficient());
            GenericSigner signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new NullDigest());
            signer.init(true, new ParametersWithRandom(key, new SecureRandom()));
            signer.update(hash, 0, hash.length);
            return signer.generateSignature();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (UnrecoverableEntryException e) {
            String msg = "Private key entry couldn't be recovered from keystore. May a wrong password is used.";
            throw new CredentialPermissionDenied(msg, e);
        }
        catch (KeyStoreException e) {
            throw new SignatureException(e);
        }
        catch (CryptoException e) {
            throw new SignatureException(e);
        }
    }

    private Certificate convertToBCCertificate(byte[] certificateBytes) {
        org.openecard.bouncycastle.asn1.x509.Certificate x509Certificate = org.openecard.bouncycastle.asn1.x509.Certificate.getInstance(certificateBytes);
        org.openecard.bouncycastle.asn1.x509.Certificate[] certs = new org.openecard.bouncycastle.asn1.x509.Certificate[]{x509Certificate};
        Certificate cert = new Certificate(certs);
        return cert;
    }
}

