/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.List;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.crypto.common.asn1.cvc.PublicKey;
import org.openecard.crypto.common.asn1.cvc.PublicKeyReference;

public class CardVerifiableCertificate {
    private static final int TAG_CVC = 32545;
    private static final int TAG_BODY = 32590;
    private static final int TAG_SIGNATURE = 24375;
    private static final int TAG_CPI = 24361;
    private static final int TAG_CAR = 66;
    private static final int TAG_PUBLIC_KEY = 32585;
    private static final int TAG_CHR = 24352;
    private static final int TAG_CHAT = 32588;
    private static final int TAG_EFFECTIVE_DATE = 24357;
    private static final int TAG_EXPIRATION_DATE = 24356;
    private static final int TAG_EXTENSION = 101;
    private byte[] body;
    private byte[] signature;
    private byte[] cpi;
    private PublicKeyReference car;
    private PublicKeyReference chr;
    private PublicKey publicKey;
    private CHAT chat;
    private Calendar effectiveDate;
    private Calendar expirationDate;
    private byte[] extensions;
    private TLV certificate;

    public CardVerifiableCertificate(byte[] cvc) throws CertificateException, TLVException {
        this(TLV.fromBER(cvc));
    }

    public CardVerifiableCertificate(TLV cvc) throws CertificateException {
        try {
            this.certificate = cvc;
            TLV bodyObject = cvc.findChildTags(32590L).get(0);
            this.body = bodyObject.getValue();
            TLV signatureObject = cvc.findChildTags(24375L).get(0);
            this.signature = signatureObject.getValue();
            List<TLV> bodyElements = bodyObject.getChild().asList();
            for (TLV item : bodyElements) {
                int itemTag = (int)item.getTagNumWithClass();
                switch (itemTag) {
                    case 24361: {
                        this.cpi = bodyObject.findChildTags(24361L).get(0).getValue();
                        break;
                    }
                    case 66: {
                        this.car = new PublicKeyReference(bodyObject.findChildTags(66L).get(0).getValue());
                        break;
                    }
                    case 32585: {
                        this.publicKey = PublicKey.getInstance(bodyObject.findChildTags(32585L).get(0));
                        break;
                    }
                    case 24352: {
                        this.chr = new PublicKeyReference(bodyObject.findChildTags(24352L).get(0).getValue());
                        break;
                    }
                    case 32588: {
                        this.chat = new CHAT(bodyObject.findChildTags(32588L).get(0));
                        break;
                    }
                    case 24357: {
                        TLV effectiveDateObject = bodyObject.findChildTags(24357L).get(0);
                        this.effectiveDate = this.parseDate(effectiveDateObject.getValue());
                        break;
                    }
                    case 24356: {
                        TLV expirationDateObject = bodyObject.findChildTags(24356L).get(0);
                        this.expirationDate = this.parseDate(expirationDateObject.getValue());
                        break;
                    }
                    case 101: {
                        this.extensions = bodyObject.findChildTags(101L).get(0).getValue();
                        break;
                    }
                }
            }
            this.verify();
        }
        catch (Exception e) {
            throw new CertificateEncodingException("Malformed CardVerifiableCertificates: " + e.getMessage());
        }
    }

    private void verify() throws CertificateEncodingException {
        if (this.body == null || this.cpi == null || this.car == null || this.publicKey == null || this.chr == null || this.chat == null || this.effectiveDate == null || this.expirationDate == null || this.signature == null) {
            throw new CertificateEncodingException("Malformed CardVerifiableCertificates");
        }
    }

    private Calendar parseDate(byte[] date) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000 + date[0] * 10 + date[1]);
        cal.set(2, date[2] * 10 + date[3] - 1);
        cal.set(5, date[4] * 10 + date[5]);
        return cal;
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public CHAT getCHAT() {
        return this.chat;
    }

    public PublicKeyReference getCHR() {
        return this.chr;
    }

    public PublicKeyReference getCAR() {
        return this.car;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getCPI() {
        return this.cpi;
    }

    public Calendar getEffectiveDate() {
        return this.effectiveDate;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public byte[] getExtensions() {
        return this.extensions;
    }

    public TLV getCertificate() {
        return this.certificate;
    }

    public boolean compare(CardVerifiableCertificate certificate) {
        return ByteUtils.compare(this.getSignature(), certificate.getSignature());
    }
}

