/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.interceptor;

import java.io.IOException;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.HttpResponseInterceptor;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.message.BasicHttpRequest;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.binding.http.common.HeaderTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger _logger = LoggerFactory.getLogger(CORSResponseInterceptor.class);

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        httpResponse.setHeader(HeaderTypes.ACCESS_CONTROL_ALLOW_ORIGIN.fieldName(), "*");
        if (((BasicHttpRequest)httpContext.getAttribute("http.request")).getParams().isParameterTrue("disable-CORS-redirect") && httpResponse.getStatusLine().getStatusCode() == 303) {
            _logger.debug("CORS redirect not supported");
            Header locationHeader = httpResponse.getLastHeader(HeaderTypes.LOCATION.fieldName());
            if (locationHeader != null && locationHeader.getValue() != null) {
                httpResponse.setEntity(new StringEntity(locationHeader.getValue()));
                httpResponse.removeHeader(locationHeader);
                httpResponse.setStatusLine(httpResponse.getStatusLine().getProtocolVersion(), 200);
            }
        }
    }
}

