/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal;

import java.util.Collection;
import org.openecard.common.sal.exception.IncorrectParameterException;
import org.openecard.common.sal.exception.NamedEntityNotFoundException;
import org.openecard.common.sal.exception.SecurityConditionNotSatisfiedException;
import org.openecard.common.sal.state.CardStateEntry;

public final class Assert {
    public static void assertNamedEntityNotFound(Object value, String message) throws NamedEntityNotFoundException {
        if (value == null) {
            throw new NamedEntityNotFoundException(message);
        }
    }

    public static void assertIncorrectParameter(Object value, String message) throws IncorrectParameterException {
        if (value == null) {
            throw new IncorrectParameterException(message);
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IncorrectParameterException(message);
        }
    }

    public static void securityConditionApplication(CardStateEntry entry, byte[] applicationID, Enum<?> action) throws SecurityConditionNotSatisfiedException {
        if (!entry.checkApplicationSecurityCondition(applicationID, action)) {
            throw new SecurityConditionNotSatisfiedException();
        }
    }

    public static void securityConditionDataSet(CardStateEntry entry, byte[] applicationID, String dataSetName, Enum<?> action) throws SecurityConditionNotSatisfiedException {
        if (!entry.checkDataSetSecurityCondition(applicationID, dataSetName, action)) {
            throw new SecurityConditionNotSatisfiedException();
        }
    }

    public static void securityConditionDID(CardStateEntry entry, byte[] applicationID, String didName, Enum<?> action) throws SecurityConditionNotSatisfiedException {
        if (!entry.checkDIDSecurityCondition(applicationID, didName, action)) {
            throw new SecurityConditionNotSatisfiedException();
        }
    }
}

