/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openecard.common.apdu.ReadBinary;
import org.openecard.common.apdu.ReadRecord;
import org.openecard.common.apdu.Select;
import org.openecard.common.apdu.UpdateRecord;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.DataElements;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.util.ShortUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardUtils {
    private static final Logger logger = LoggerFactory.getLogger(CardUtils.class);

    public static void selectMF(Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        Select.MasterFile selectMF = new Select.MasterFile();
        selectMF.transmit(dispatcher, slotHandle);
    }

    public static void selectFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        CardUtils.selectFile(dispatcher, slotHandle, ShortUtils.toByteArray(fileID));
    }

    public static CardResponseAPDU selectFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        Select.ChildFile selectFile = new Select.ChildFile(fileID);
        selectFile.setFCP();
        return selectFile.transmit(dispatcher, slotHandle);
    }

    public static byte[] readFile(FCP fcp, Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte length = -1;
        int i = 0;
        try {
            CardResponseAPDU response;
            do {
                if (!CardUtils.isRecordEF(fcp)) {
                    ReadBinary readBinary = new ReadBinary((short)(i * (length & 0xFF)), length);
                    response = readBinary.transmit(dispatcher, slotHandle, CardCommandStatus.response(36864, 25218));
                } else {
                    ReadRecord readRecord = new ReadRecord();
                    response = readRecord.transmit(dispatcher, slotHandle, CardCommandStatus.response(36864, 25218));
                }
                baos.write(response.getData());
                ++i;
            } while (response.isNormalProcessed());
            baos.close();
        }
        catch (IOException e) {
            throw new APDUException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] readFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        return CardUtils.readFile(dispatcher, slotHandle, ShortUtils.toByteArray(fileID));
    }

    public static byte[] readFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        CardResponseAPDU selectResponse = CardUtils.selectFile(dispatcher, slotHandle, fileID);
        FCP fcp = null;
        try {
            fcp = new FCP(selectResponse.getData());
        }
        catch (TLVException e) {
            logger.warn("Couldn't get File Control Parameters from Select response.", e);
        }
        return CardUtils.readFile(fcp, dispatcher, slotHandle);
    }

    private static boolean isRecordEF(FCP fcp) {
        if (fcp == null) {
            return false;
        }
        DataElements dataElements = fcp.getDataElements();
        return dataElements.isLinear() || dataElements.isCyclic();
    }

    public static void writeFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID, byte[] data) throws APDUException {
        CardResponseAPDU selectResponse = CardUtils.selectFile(dispatcher, slotHandle, fileID);
        FCP fcp = null;
        try {
            fcp = new FCP(selectResponse.getData());
        }
        catch (TLVException e) {
            logger.warn("Couldn't get File Control Parameters from Select response.", e);
        }
        CardUtils.writeFile(fcp, dispatcher, slotHandle, data);
    }

    private static void writeFile(FCP fcp, Dispatcher dispatcher, byte[] slotHandle, byte[] data) throws APDUException {
        if (!CardUtils.isRecordEF(fcp)) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        UpdateRecord updateRecord = new UpdateRecord(data);
        updateRecord.transmit(dispatcher, slotHandle);
    }
}

