/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.x509.Extensions;
import org.openecard.bouncycastle.asn1.x509.KeyUsage;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.digests.MD5Digest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.digests.SHA224Digest;
import org.openecard.bouncycastle.crypto.digests.SHA256Digest;
import org.openecard.bouncycastle.crypto.digests.SHA384Digest;
import org.openecard.bouncycastle.crypto.digests.SHA512Digest;
import org.openecard.bouncycastle.crypto.macs.HMac;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CombinedHash;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsDSSSigner;
import org.openecard.bouncycastle.crypto.tls.TlsECDSASigner;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsRSASigner;
import org.openecard.bouncycastle.crypto.tls.TlsSigner;
import org.openecard.bouncycastle.crypto.util.PublicKeyFactory;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.Integers;
import org.openecard.bouncycastle.util.Strings;
import org.openecard.bouncycastle.util.io.Streams;

public class TlsUtils {
    public static byte[] EMPTY_BYTES = new byte[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    public static final Integer EXT_server_name_indication = Integers.valueOf(0);
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    static final byte[][] SSL3_CONST = TlsUtils.genConst();

    public static boolean isValidUint8(short i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint16(int i) {
        return (i & 0xFFFF) == i;
    }

    public static boolean isValidUint24(int i) {
        return (i & 0xFFFFFF) == i;
    }

    public static boolean isValidUint32(long i) {
        return (i & 0xFFFFFFFFL) == i;
    }

    public static boolean isValidUint48(long i) {
        return (i & 0xFFFFFFFFFFFFL) == i;
    }

    public static boolean isValidUint64(long i) {
        return true;
    }

    public static void writeUint8(short i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(short i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint16(int i, OutputStream output) throws IOException {
        output.write(i >> 8);
        output.write(i);
    }

    public static void writeUint16(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 8);
        buf[offset + 1] = (byte)i;
    }

    public static void writeUint24(int i, OutputStream output) throws IOException {
        output.write(i >> 16);
        output.write(i >> 8);
        output.write(i);
    }

    public static void writeUint24(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 16);
        buf[offset + 1] = (byte)(i >> 8);
        buf[offset + 2] = (byte)i;
    }

    public static void writeUint32(long i, OutputStream output) throws IOException {
        output.write((int)(i >> 24));
        output.write((int)(i >> 16));
        output.write((int)(i >> 8));
        output.write((int)i);
    }

    public static void writeUint32(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 24);
        buf[offset + 1] = (byte)(i >> 16);
        buf[offset + 2] = (byte)(i >> 8);
        buf[offset + 3] = (byte)i;
    }

    public static void writeUint48(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 40);
        buf[offset + 1] = (byte)(i >> 32);
        buf[offset + 2] = (byte)(i >> 24);
        buf[offset + 3] = (byte)(i >> 16);
        buf[offset + 4] = (byte)(i >> 8);
        buf[offset + 5] = (byte)i;
    }

    public static void writeUint64(long i, OutputStream output) throws IOException {
        output.write((int)(i >> 56));
        output.write((int)(i >> 48));
        output.write((int)(i >> 40));
        output.write((int)(i >> 32));
        output.write((int)(i >> 24));
        output.write((int)(i >> 16));
        output.write((int)(i >> 8));
        output.write((int)i);
    }

    public static void writeUint64(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 56);
        buf[offset + 1] = (byte)(i >> 48);
        buf[offset + 2] = (byte)(i >> 40);
        buf[offset + 3] = (byte)(i >> 32);
        buf[offset + 4] = (byte)(i >> 24);
        buf[offset + 5] = (byte)(i >> 16);
        buf[offset + 6] = (byte)(i >> 8);
        buf[offset + 7] = (byte)i;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.writeUint8((short)buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint8(uints[i], output);
        }
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint16(uints[i], output);
        }
    }

    public static short readUint8(InputStream input) throws IOException {
        int i = input.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (short)i;
    }

    public static short readUint8(byte[] buf, int offset) {
        return buf[offset];
    }

    public static int readUint16(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        if (i3 < 0) {
            throw new EOFException();
        }
        return i1 << 16 | i2 << 8 | i3;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        if (i4 < 0) {
            throw new EOFException();
        }
        return (long)i1 << 24 | (long)i2 << 16 | (long)i3 << 8 | (long)i4;
    }

    public static long readUint48(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        int i5 = input.read();
        int i6 = input.read();
        if (i6 < 0) {
            throw new EOFException();
        }
        return (long)i1 << 40 | (long)i2 << 32 | (long)i3 << 24 | (long)i4 << 16 | (long)i5 << 8 | (long)i6;
    }

    public static long readUint48(byte[] buf, int offset) {
        int hi = TlsUtils.readUint24(buf, offset);
        int lo = TlsUtils.readUint24(buf, offset + 3);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        if (length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
        return buf;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int length = buf.length;
        if (length > 0 && length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short length = TlsUtils.readUint8(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int length = TlsUtils.readUint24(input);
        return TlsUtils.readFully(length, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] uints = new short[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint8(input);
        }
        return uints;
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] uints = new int[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint16(input);
        }
        return uints;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) throws IOException {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(i1, i2);
    }

    public static int readVersionRaw(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int t = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t >> 24);
        buf[offset + 1] = (byte)(t >> 16);
        buf[offset + 2] = (byte)(t >> 8);
        buf[offset + 3] = (byte)t;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) throws IOException {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 1));
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion clientVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(clientVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms));
    }

    public static void addServerNameIndicationExtension(Hashtable extensions, Vector serverNames) throws IOException {
        extensions.put(EXT_server_name_indication, TlsUtils.createServerNameIndicationExtension(serverNames));
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable extensions) throws IOException {
        if (extensions == null) {
            return null;
        }
        byte[] extensionValue = (byte[])extensions.get(EXT_signature_algorithms);
        if (extensionValue == null) {
            return null;
        }
        return TlsUtils.readSignatureAlgorithmsExtension(extensionValue);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector supportedSignatureAlgorithms) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint16(2 * supportedSignatureAlgorithms.size(), buf);
        for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            entry.encode(buf);
        }
        return buf.toByteArray();
    }

    public static byte[] createServerNameIndicationExtension(Vector serverNames) throws IOException {
        if (serverNames == null || serverNames.size() < 1 || serverNames.size() >= 32768) {
            throw new IllegalArgumentException("'serverNames' must have length from 1 to (2^15 - 1)");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ByteArrayOutputStream serverList = new ByteArrayOutputStream();
        for (int i = 0; i < serverNames.size(); ++i) {
            String serverName = (String)serverNames.elementAt(i);
            if (serverName.isEmpty()) continue;
            serverList.write(0);
            TlsUtils.writeOpaque16(serverName.getBytes(), serverList);
        }
        TlsUtils.writeOpaque16(serverList.toByteArray(), buf);
        return buf.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] extensionValue) throws IOException {
        if (extensionValue == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionValue);
        int length = TlsUtils.readUint16(buf);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int count = length / 2;
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>(count);
        for (int i = 0; i < count; ++i) {
            SignatureAndHashAlgorithm entry = SignatureAndHashAlgorithm.parse(buf);
            result.addElement(entry);
        }
        TlsProtocol.assertEmpty(buf);
        return result;
    }

    public static byte[] PRF(TlsContext context, byte[] secret, String asciiLabel, byte[] seed, int size) {
        ProtocolVersion version = context.getServerVersion();
        if (version.isSSL()) {
            throw new IllegalStateException("No PRF available for SSLv3 session");
        }
        byte[] label = Strings.toByteArray(asciiLabel);
        byte[] labelSeed = TlsUtils.concat(label, seed);
        int prfAlgorithm = context.getSecurityParameters().getPrfAlgorithm();
        if (prfAlgorithm == 0) {
            if (!ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion())) {
                return TlsUtils.PRF_legacy(secret, label, labelSeed, size);
            }
            prfAlgorithm = 1;
        }
        Digest prfDigest = TlsUtils.createPRFHash(prfAlgorithm);
        byte[] buf = new byte[size];
        TlsUtils.hmac_hash(prfDigest, secret, labelSeed, buf);
        return buf;
    }

    static byte[] PRF_legacy(byte[] secret, byte[] label, byte[] labelSeed, int size) {
        int s_half = (secret.length + 1) / 2;
        byte[] s1 = new byte[s_half];
        byte[] s2 = new byte[s_half];
        System.arraycopy(secret, 0, s1, 0, s_half);
        System.arraycopy(secret, secret.length - s_half, s2, 0, s_half);
        byte[] b1 = new byte[size];
        byte[] b2 = new byte[size];
        TlsUtils.hmac_hash(new MD5Digest(), s1, labelSeed, b1);
        TlsUtils.hmac_hash(new SHA1Digest(), s2, labelSeed, b2);
        for (int i = 0; i < size; ++i) {
            int n = i;
            b1[n] = (byte)(b1[n] ^ b2[i]);
        }
        return b1;
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    static void hmac_hash(Digest digest, byte[] secret, byte[] seed, byte[] out) {
        HMac mac = new HMac(digest);
        KeyParameter param = new KeyParameter(secret);
        byte[] a = seed;
        int size = digest.getDigestSize();
        int iterations = (out.length + size - 1) / size;
        byte[] buf = new byte[mac.getMacSize()];
        byte[] buf2 = new byte[mac.getMacSize()];
        for (int i = 0; i < iterations; ++i) {
            mac.init(param);
            mac.update(a, 0, a.length);
            mac.doFinal(buf, 0);
            a = buf;
            mac.init(param);
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(buf2, 0);
            System.arraycopy(buf2, 0, out, size * i, Math.min(size, out.length - size * i));
        }
    }

    static void validateKeyUsage(org.openecard.bouncycastle.asn1.x509.Certificate c, int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ku = KeyUsage.fromExtensions(exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] calculateKeyBlock(TlsContext context, int size) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] master_secret = securityParameters.getMasterSecret();
        byte[] seed = TlsUtils.concat(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        if (context.getServerVersion().isSSL()) {
            return TlsUtils.calculateKeyBlock_SSL(master_secret, seed, size);
        }
        return TlsUtils.PRF(context, master_secret, "key expansion", seed, size);
    }

    static byte[] calculateKeyBlock_SSL(byte[] master_secret, byte[] random, int size) {
        MD5Digest md5 = new MD5Digest();
        SHA1Digest sha1 = new SHA1Digest();
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] tmp = new byte[size + md5Size];
        int i = 0;
        int pos = 0;
        while (pos < size) {
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(master_secret, 0, master_secret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(master_secret, 0, master_secret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(tmp, pos);
            pos += md5Size;
            ++i;
        }
        byte[] rval = new byte[size];
        System.arraycopy(tmp, 0, rval, 0, size);
        return rval;
    }

    static byte[] calculateMasterSecret(TlsContext context, byte[] pre_master_secret) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] seed = TlsUtils.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        if (context.getServerVersion().isSSL()) {
            return TlsUtils.calculateMasterSecret_SSL(pre_master_secret, seed);
        }
        return TlsUtils.PRF(context, pre_master_secret, "master secret", seed, 48);
    }

    static byte[] calculateMasterSecret_SSL(byte[] pre_master_secret, byte[] random) {
        MD5Digest md5 = new MD5Digest();
        SHA1Digest sha1 = new SHA1Digest();
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] rval = new byte[md5Size * 3];
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(pre_master_secret, 0, pre_master_secret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(pre_master_secret, 0, pre_master_secret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(rval, pos);
            pos += md5Size;
        }
        return rval;
    }

    static byte[] calculateVerifyData(TlsContext context, String asciiLabel, byte[] handshakeHash) {
        if (context.getServerVersion().isSSL()) {
            return handshakeHash;
        }
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] master_secret = securityParameters.getMasterSecret();
        int verify_data_length = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(context, master_secret, asciiLabel, handshakeHash, verify_data_length);
    }

    public static final Digest createHash(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static final Digest cloneHash(int hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static final Digest createPRFHash(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                return new CombinedHash();
            }
        }
        return TlsUtils.createHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
    }

    public static final Digest clonePRFHash(int prfAlgorithm, Digest hash) {
        switch (prfAlgorithm) {
            case 0: {
                return new CombinedHash((CombinedHash)hash);
            }
        }
        return TlsUtils.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm), hash);
    }

    public static final short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm");
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    static short getClientCertificateType(Certificate clientCertificate, Certificate serverCertificate) throws IOException {
        if (clientCertificate.isEmpty()) {
            return -1;
        }
        org.openecard.bouncycastle.asn1.x509.Certificate x509Cert = clientCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(keyInfo);
            if (publicKey.isPrivate()) {
                throw new TlsFatalAlert(80);
            }
            if (publicKey instanceof RSAKeyParameters) {
                TlsUtils.validateKeyUsage(x509Cert, 128);
                return 1;
            }
            if (publicKey instanceof DSAPublicKeyParameters) {
                TlsUtils.validateKeyUsage(x509Cert, 128);
                return 2;
            }
            if (publicKey instanceof ECPublicKeyParameters) {
                TlsUtils.validateKeyUsage(x509Cert, 128);
                return 64;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new TlsFatalAlert(43);
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static TlsSigner createTlsSigner(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return new TlsDSSSigner();
            }
            case 64: {
                return new TlsECDSASigner();
            }
            case 1: {
                return new TlsRSASigner();
            }
        }
        throw new IllegalArgumentException("'clientCertificateType' is not a type with signing capability");
    }

    private static byte[][] genConst() {
        int n = 10;
        byte[][] arr = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] b = new byte[i + 1];
            Arrays.fill(b, (byte)(65 + i));
            arr[i] = b;
        }
        return arr;
    }

    private static Vector vectorOfOne(Object obj) {
        Vector<Object> v = new Vector<Object>(1);
        v.addElement(obj);
        return v;
    }
}

