/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.tls.DefaultTlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsAuthentication;
import org.openecard.bouncycastle.crypto.tls.TlsCipherFactory;
import org.openecard.crypto.tls.ClientCertTlsClient;
import org.openecard.crypto.tls.TlsNoAuthentication;

public class ClientCertDefaultTlsClient
extends DefaultTlsClient
implements ClientCertTlsClient {
    private final String fqdn;
    private TlsAuthentication tlsAuth;

    public ClientCertDefaultTlsClient(String fqdn) {
        super(fqdn);
        this.fqdn = fqdn;
    }

    public ClientCertDefaultTlsClient(TlsCipherFactory tcf, String fqdn) {
        super(tcf, fqdn);
        this.fqdn = fqdn;
    }

    @Override
    public synchronized TlsAuthentication getAuthentication() throws IOException {
        if (this.tlsAuth == null) {
            TlsNoAuthentication tlsAuthTmp = new TlsNoAuthentication();
            tlsAuthTmp.setHostname(this.fqdn);
            this.tlsAuth = tlsAuthTmp;
        }
        return this.tlsAuth;
    }

    @Override
    public synchronized void setAuthentication(TlsAuthentication tlsAuth) {
        this.tlsAuth = tlsAuth;
    }
}

