/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.crypto.common.asn1.eac.SubjectPublicKeyInfo;

public class CAPublicKeyInfo {
    private String protocol;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private int keyID;

    public CAPublicKeyInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(1));
        } else if (seq.size() == 3) {
            this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(1));
            this.keyID = ASN1Integer.getInstance(seq.getObjectAt(2)).getValue().intValue();
        } else {
            throw new IllegalArgumentException("Sequence wrong size for CAPublicKeyInfo");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public int getKeyID() {
        return this.keyID;
    }
}

