/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.soap;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.openecard.ws.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPElement {
    protected final Element element;

    protected SOAPElement(Element element) {
        this.element = element;
    }

    public List<Element> getChildElements() {
        LinkedList<Element> result = new LinkedList<Element>();
        NodeList nodes = this.element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (1 != n.getNodeType()) continue;
            result.add((Element)n);
        }
        return result;
    }

    public Element addChildElement(Element parent, QName elementName) throws SOAPException {
        Document doc = this.element.getOwnerDocument();
        if (doc != parent.getOwnerDocument()) {
            throw new SOAPException("Given nodes have different owner documents.");
        }
        Element e = doc.createElementNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        return (Element)parent.appendChild(e);
    }

    public Element addChildElement(QName elementName) throws SOAPException {
        return this.addChildElement(this.element, elementName);
    }
}

