/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.openecard.common.util.FileUtils;

public final class PluginProperties {
    private static final String COMMENT = "This file stores the activation status of the available plugins.";
    private static final String FALSE = Boolean.toString(false);
    private static final String PLUGIN_PROPERTIES_FILE = "plugin.properties";
    private static final Properties props = new Properties();

    public static void loadProperties() throws IOException {
        FileInputStream is = null;
        File cfgDir = FileUtils.getHomeConfigDir();
        String propFileStr = cfgDir + File.separator + PLUGIN_PROPERTIES_FILE;
        File propFile = new File(propFileStr);
        if (!propFile.exists()) {
            propFile.createNewFile();
        }
        is = new FileInputStream(propFile);
        props.load(is);
    }

    static String getProperty(String key) {
        return props.getProperty(key, FALSE);
    }

    static Object setProperty(String key, String value) {
        return props.setProperty(key, value);
    }

    public static void saveProperties() throws IOException {
        File cfgDir = FileUtils.getHomeConfigDir();
        String logFileStr = cfgDir + File.separator + PLUGIN_PROPERTIES_FILE;
        File logFile = new File(logFileStr);
        FileOutputStream out = new FileOutputStream(logFile);
        props.store(out, COMMENT);
    }
}

