/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.cvc.ECPublicKey;
import org.openecard.crypto.common.asn1.cvc.RSAPublicKey;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;

public abstract class PublicKey {
    protected static final int OID_TAG = 6;

    public static PublicKey getInstance(byte[] key) throws Exception {
        return PublicKey.getInstance(TLV.fromBER(key));
    }

    public static PublicKey getInstance(TLV key) throws Exception {
        try {
            String oid = ObjectIdentifierUtils.toString(key.findChildTags(6L).get(0).getValue());
            if (oid.startsWith("0.4.0.127.0.7.2.2.2.2")) {
                return new ECPublicKey(key);
            }
            if (oid.startsWith("0.4.0.127.0.7.2.2.2.1")) {
                return new RSAPublicKey(key);
            }
            throw new IllegalArgumentException("Cannot handle object identifier");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed public key: " + e.getMessage());
        }
    }

    public boolean compare(PublicKey pk) {
        try {
            return ByteUtils.compare(this.getTLVEncoded().toBER(), pk.getTLVEncoded().toBER());
        }
        catch (TLVException ignore) {
            return false;
        }
    }

    public abstract String getObjectIdentifier();

    public abstract TLV getTLVEncoded();
}

