/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVType;

public class Certificate
extends TLVType {
    private TLV toBeSigned;
    private TLV algorithmIdentifier;
    private TLVBitString encrypted;

    public Certificate(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(Tag.SEQUENCE_TAG)) {
            throw new TLVException("toBeSigned element missing.");
        }
        this.toBeSigned = p.next(0);
        if (!p.match(Tag.SEQUENCE_TAG)) {
            throw new TLVException("algorithmIdentifier element missing.");
        }
        this.algorithmIdentifier = p.next(0);
        if (!p.match(Tag.BITSTRING_TAG)) {
            throw new TLVException("encrypted element missing.");
        }
        this.encrypted = new TLVBitString(p.next(0));
    }
}

