/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.io.HttpConnectProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySettings {
    private static final Logger logger = LoggerFactory.getLogger(ProxySettings.class);
    private static final ProxySettings defaultInstance = new ProxySettings();
    private static final Proxy systemProxy;
    private final Proxy proxy;

    public ProxySettings() {
        this.proxy = null;
    }

    private ProxySettings(Proxy proxy) {
        this.proxy = proxy;
    }

    public static ProxySettings getDefault() {
        return defaultInstance;
    }

    private Proxy getProxy(String hostname, int port) throws URISyntaxException {
        Proxy p;
        if (this.proxy == null) {
            if (systemProxy != null) {
                p = systemProxy;
            } else {
                ProxySelector selector = ProxySelector.getDefault();
                p = selector.select(new URI("socket://" + hostname + ":" + port)).get(0);
            }
        } else {
            p = this.proxy;
        }
        logger.debug("Selecting proxy: {}", (Object)p);
        return p;
    }

    public Socket getSocket(String hostname, int port) throws IOException, URISyntaxException {
        Socket sock;
        Proxy p = this.getProxy(hostname, port);
        if (p instanceof HttpConnectProxy) {
            HttpConnectProxy hp = (HttpConnectProxy)p;
            sock = hp.getSocket(hostname, port);
        } else {
            sock = new Socket(this.getProxy(hostname, port));
            InetSocketAddress addr = new InetSocketAddress(hostname, port);
            sock.setKeepAlive(true);
            sock.setSoTimeout(300000);
            sock.connect(addr, 60000);
        }
        return sock;
    }

    static {
        Proxy p = null;
        String host = OpenecardProperties.getProperty("proxy.socks.host");
        String port = OpenecardProperties.getProperty("proxy.socks.port");
        try {
            if (host != null && port != null) {
                p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, Integer.parseInt(port)));
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (p == null) {
            String scheme = OpenecardProperties.getProperty("proxy.http.scheme");
            String validateTls = OpenecardProperties.getProperty("proxy.http.validate_tls");
            host = OpenecardProperties.getProperty("proxy.http.host");
            port = OpenecardProperties.getProperty("proxy.http.port");
            String user = OpenecardProperties.getProperty("proxy.http.user");
            String pass = OpenecardProperties.getProperty("proxy.http.pass");
            try {
                boolean validate = true;
                if (validateTls != null) {
                    validate = Boolean.parseBoolean(validateTls);
                }
                if (scheme != null && host != null && port != null) {
                    if (!"http".equals(scheme = scheme.toLowerCase()) && !"https".equals(scheme)) {
                        logger.warn("Unsupported scheme {} used, falling back to http.", (Object)scheme);
                        scheme = "http";
                    }
                    p = new HttpConnectProxy(scheme, validate, host, Integer.parseInt(port), user, pass);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        systemProxy = p;
    }
}

