/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import org.openecard.bouncycastle.crypto.AsymmetricBlockCipher;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.CryptoException;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.openecard.bouncycastle.crypto.engines.RSABlindedEngine;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.crypto.signers.GenericSigner;
import org.openecard.bouncycastle.crypto.signers.RSADigestSigner;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsSigner;
import org.openecard.bouncycastle.crypto.tls.CombinedHash;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.util.Arrays;

public class TlsRSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(AsymmetricKeyParameter privateKey, byte[] md5AndSha1) throws CryptoException {
        AsymmetricBlockCipher engine = this.createRSAImpl();
        engine.init(true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        return engine.processBlock(md5AndSha1, 0, md5AndSha1.length);
    }

    @Override
    public boolean verifyRawSignature(byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] md5AndSha1) throws CryptoException {
        AsymmetricBlockCipher engine = this.createRSAImpl();
        engine.init(false, publicKey);
        byte[] signed = engine.processBlock(sigBytes, 0, sigBytes.length);
        return Arrays.constantTimeAreEqual(signed, md5AndSha1);
    }

    @Override
    public Signer createSigner(AsymmetricKeyParameter privateKey) {
        return this.makeSigner(new CombinedHash(), true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
    }

    @Override
    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        return this.makeSigner(new CombinedHash(), false, publicKey);
    }

    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }

    protected Signer makeSigner(Digest d, boolean forSigning, CipherParameters cp) {
        Signer s = ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(this.context.getServerVersion().getEquivalentTLSVersion()) ? new RSADigestSigner(d) : new GenericSigner(this.createRSAImpl(), d);
        s.init(forSigning, cp);
        return s;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

