/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

class DeferredHash
implements TlsHandshakeHash {
    protected TlsContext context;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private int prfAlgorithm = -1;
    private Digest hash = null;

    DeferredHash() {
        this.buf = new ByteArrayOutputStream();
        this.hash = null;
    }

    private DeferredHash(Digest hash) {
        this.buf = null;
        this.hash = hash;
    }

    @Override
    public void init(TlsContext context) {
        this.context = context;
    }

    @Override
    public TlsHandshakeHash commit() {
        int prfAlgorithm = this.context.getSecurityParameters().getPrfAlgorithm();
        Digest prfHash = TlsUtils.createPRFHash(prfAlgorithm);
        byte[] data = this.buf.toByteArray();
        prfHash.update(data, 0, data.length);
        if (prfHash instanceof TlsHandshakeHash) {
            TlsHandshakeHash tlsPRFHash = (TlsHandshakeHash)prfHash;
            tlsPRFHash.init(this.context);
            return tlsPRFHash.commit();
        }
        this.prfAlgorithm = prfAlgorithm;
        this.hash = prfHash;
        this.buf = null;
        return this;
    }

    @Override
    public TlsHandshakeHash fork() {
        this.checkHash();
        return new DeferredHash(TlsUtils.clonePRFHash(this.prfAlgorithm, this.hash));
    }

    @Override
    public String getAlgorithmName() {
        this.checkHash();
        return this.hash.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        this.checkHash();
        return this.hash.getDigestSize();
    }

    @Override
    public void update(byte input) {
        if (this.hash == null) {
            this.buf.write(input);
        } else {
            this.hash.update(input);
        }
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (this.hash == null) {
            this.buf.write(input, inOff, len);
        } else {
            this.hash.update(input, inOff, len);
        }
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        this.checkHash();
        return this.hash.doFinal(output, outOff);
    }

    @Override
    public void reset() {
        if (this.hash == null) {
            this.buf.reset();
        } else {
            this.hash.reset();
        }
    }

    protected void checkHash() {
        if (this.hash == null) {
            throw new IllegalStateException("No hash algorithm has been set");
        }
    }
}

