/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.plugins.pinplugin.AbstractPINAction;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.ChangePINDialog;
import org.openecard.plugins.wrapper.PluginDispatcher;
import org.openecard.plugins.wrapper.PluginUserConsent;
import org.openecard.recognition.CardRecognition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePINAction
extends AbstractPINAction {
    private static final Logger logger = LoggerFactory.getLogger(ChangePINAction.class);
    private static final String ID = "ChangePINAction";

    public ChangePINAction(PluginDispatcher dispatcher, PluginUserConsent gui, CardRecognition rec, CardStateMap map) {
        super(dispatcher, gui, rec, map);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return this.lang.translationForKey("action.changepin.name", new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.lang.translationForKey("action.changepin.description", new Object[0]);
    }

    @Override
    public InputStream getLogo() {
        return null;
    }

    @Override
    public void perform() throws DispatcherException, InvocationTargetException {
        boolean nativePace;
        ConnectionHandleType cHandle = this.waitForCardType("http://bsi.bund.de/cif/npa.xml");
        if (cHandle == null) {
            logger.debug("User cancelled card insertion.");
            return;
        }
        cHandle = this.connectToRootApplication(cHandle);
        RecognizedState pinState = this.recognizeState(cHandle);
        try {
            nativePace = this.genericPACESupport(cHandle);
        }
        catch (WSHelper.WSException e) {
            logger.error("Could not get capabilities from reader.");
            return;
        }
        ChangePINDialog uc = new ChangePINDialog(this.gui, this.dispatcher, cHandle, pinState, !nativePace);
        uc.show();
        Disconnect d = new Disconnect();
        d.setSlotHandle(cHandle.getSlotHandle());
        this.dispatcher.deliver(d);
    }

    @Override
    public boolean isMainActivity() {
        return false;
    }
}

