/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.Radiobox;
import org.openecard.gui.swing.components.StepComponent;

public class Radiobutton
implements StepComponent {
    private final Radiobox result;
    private final ArrayList<JRadioButton> buttons;
    private final JPanel panel;

    public Radiobutton(Radiobox radio) {
        this.result = new Radiobox(radio.getID());
        this.panel = new JPanel();
        GridLayout layout = new GridLayout(0, 1);
        this.panel.setLayout(layout);
        ButtonGroup bg = new ButtonGroup();
        this.buttons = new ArrayList(radio.getBoxItems().size());
        for (BoxItem next : radio.getBoxItems()) {
            BoxItem copy = new BoxItem();
            this.result.getBoxItems().add(copy);
            copy.setName(next.getName());
            copy.setText(next.getText());
            copy.setDisabled(next.isDisabled());
            JRadioButton component = new JRadioButton(next.getText() == null ? "" : next.getText(), next.isChecked());
            bg.add(component);
            if (next.isDisabled()) {
                component.setEnabled(false);
            }
            if (next.isChecked()) {
                component.setSelected(true);
            }
            this.panel.add(component);
            this.buttons.add(component);
        }
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public boolean validate() {
        int numSelected = 0;
        for (JRadioButton next : this.buttons) {
            if (!next.isSelected()) continue;
            ++numSelected;
        }
        return numSelected == 1;
    }

    @Override
    public boolean isValueType() {
        return true;
    }

    @Override
    public OutputInfoUnit getValue() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            JRadioButton component = this.buttons.get(i);
            this.result.getBoxItems().get(i).setChecked(component.isSelected());
        }
        return this.result;
    }
}

