/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.crypto.common.asn1.eac.SecurityInfo;

public final class PACEInfo
extends SecurityInfo {
    private String protocol = this.getIdentifier();
    private int version = ((ASN1Integer)this.getRequiredData()).getValue().intValue();
    private int parameterID = -1;
    private static final String[] protocols = new String[]{"0.4.0.127.0.7.2.2.4.1.1", "0.4.0.127.0.7.2.2.4.1.2", "0.4.0.127.0.7.2.2.4.1.3", "0.4.0.127.0.7.2.2.4.1.4", "0.4.0.127.0.7.2.2.4.3.1", "0.4.0.127.0.7.2.2.4.3.2", "0.4.0.127.0.7.2.2.4.3.3", "0.4.0.127.0.7.2.2.4.3.4", "0.4.0.127.0.7.2.2.4.2.1", "0.4.0.127.0.7.2.2.4.2.2", "0.4.0.127.0.7.2.2.4.2.3", "0.4.0.127.0.7.2.2.4.2.4", "0.4.0.127.0.7.2.2.4.4.1", "0.4.0.127.0.7.2.2.4.4.2", "0.4.0.127.0.7.2.2.4.4.3", "0.4.0.127.0.7.2.2.4.4.4"};

    public PACEInfo(ASN1Sequence seq) {
        super(seq);
        if (seq.size() == 3) {
            this.parameterID = ((ASN1Integer)this.getOptionalData()).getValue().intValue();
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getVersion() {
        return this.version;
    }

    public int getParameterID() {
        return this.parameterID;
    }

    public boolean isGM() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.4.1") || this.protocol.startsWith("0.4.0.127.0.7.2.2.4.2");
    }

    public boolean isIM() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.4.3") || this.protocol.startsWith("0.4.0.127.0.7.2.2.4.4");
    }

    public boolean isDH() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.4.1") || this.protocol.startsWith("0.4.0.127.0.7.2.2.4.3");
    }

    public boolean isECDH() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.4.2") || this.protocol.startsWith("0.4.0.127.0.7.2.2.4.4");
    }

    public static boolean isPACEObjectIdentifer(String oid) {
        for (int i = 0; i < protocols.length; ++i) {
            if (!protocols[i].equals(oid)) continue;
            return true;
        }
        return false;
    }
}

