/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.monitor;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.jci.monitor.FilesystemAlterationObserverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilesystemAlterationMonitor
implements Runnable {
    private final Log log = LogFactory.getLog(FilesystemAlterationMonitor.class);
    private final Object observersLock = new Object();
    private Map observers = Collections.unmodifiableMap(new HashMap());
    private long delay = 3000L;
    private Thread thread;
    private volatile boolean running = true;

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.running = false;
        try {
            this.thread.join(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setInterval(long pDelay) {
        this.delay = pDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(File pRoot, FilesystemAlterationListener pListener) {
        FilesystemAlterationObserver observer;
        Object object = this.observersLock;
        synchronized (object) {
            observer = (FilesystemAlterationObserver)this.observers.get(pRoot);
            if (observer == null) {
                HashMap<File, FilesystemAlterationObserver> newObservers = new HashMap<File, FilesystemAlterationObserver>(this.observers);
                observer = new FilesystemAlterationObserverImpl(pRoot);
                newObservers.put(pRoot, observer);
                this.observers = Collections.unmodifiableMap(newObservers);
            }
        }
        observer.addListener(pListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FilesystemAlterationListener pListener) {
        Object object = this.observersLock;
        synchronized (object) {
            Iterator it = this.observers.values().iterator();
            while (it.hasNext()) {
                FilesystemAlterationObserver observer = (FilesystemAlterationObserver)it.next();
                observer.removeListener(pListener);
            }
        }
    }

    public FilesystemAlterationListener[] getListenersFor(File pRoot) {
        FilesystemAlterationObserver observer = (FilesystemAlterationObserver)this.observers.get(pRoot);
        if (observer == null) {
            return new FilesystemAlterationListener[0];
        }
        return observer.getListeners();
    }

    public void run() {
        this.log.debug("fam running");
        while (this.running) {
            Map currentObservers = this.observers;
            Iterator it = currentObservers.values().iterator();
            while (it.hasNext()) {
                FilesystemAlterationObserver observer = (FilesystemAlterationObserver)it.next();
                observer.checkAndNotify();
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.debug("fam exiting");
    }
}

