/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.status;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openecard.common.enums.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.interfaces.EventManager;
import org.openecard.control.module.status.ReschedulableTimer;
import org.openecard.control.module.status.StatusChangeRequest;
import org.openecard.ws.schema.StatusChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler
implements EventCallback {
    private static final Logger logger = LoggerFactory.getLogger(EventHandler.class);
    private Map<String, LinkedBlockingQueue<StatusChange>> eventQueues = new HashMap<String, LinkedBlockingQueue<StatusChange>>();
    private Map<String, ReschedulableTimer> timers = new HashMap<String, ReschedulableTimer>();
    private static final int deleteDelay = 60000;

    public EventHandler(EventManager eventManager) {
        eventManager.registerAllEvents(this);
    }

    public StatusChange next(StatusChangeRequest statusChangeRequest) {
        String session = statusChangeRequest.getSessionIdentifier();
        StatusChange handle = null;
        LinkedBlockingQueue<StatusChange> queue = this.eventQueues.get(session);
        if (queue == null) {
            logger.error("No queue found for session {}", (Object)session);
            return null;
        }
        do {
            try {
                this.timers.get(statusChangeRequest.getSessionIdentifier()).reschedule(60000L);
                handle = this.eventQueues.get(statusChangeRequest.getSessionIdentifier()).poll(30L, TimeUnit.SECONDS);
                logger.debug("WaitForChange event pulled from event queue.");
            }
            catch (InterruptedException ex) {
                return null;
            }
        } while (handle == null);
        return handle;
    }

    @Override
    public void signalEvent(EventType eventType, Object eventData) {
        if (eventData instanceof ConnectionHandleType) {
            ConnectionHandleType connectionHandle = (ConnectionHandleType)eventData;
            for (Map.Entry<String, LinkedBlockingQueue<StatusChange>> entry : this.eventQueues.entrySet()) {
                try {
                    LinkedBlockingQueue<StatusChange> queue = entry.getValue();
                    StatusChange statusChange = new StatusChange();
                    statusChange.setAction(eventType.getEventTypeIdentifier());
                    statusChange.setConnectionHandle(connectionHandle);
                    queue.put(statusChange);
                }
                catch (InterruptedException ignore) {}
            }
        }
    }

    public void addQueue(String sessionIdentifier) {
        if (this.eventQueues.get(sessionIdentifier) == null) {
            this.eventQueues.put(sessionIdentifier, new LinkedBlockingQueue());
            ReschedulableTimer timer = new ReschedulableTimer();
            timer.schedule(new DeleteTask(sessionIdentifier), 60000L);
            this.timers.put(sessionIdentifier, timer);
        } else {
            this.timers.get(sessionIdentifier).reschedule(60000L);
        }
    }

    private final class DeleteTask
    implements Runnable {
        private final String sessionIdentifier;

        public DeleteTask(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public void run() {
            EventHandler.this.eventQueues.remove(this.sessionIdentifier);
            EventHandler.this.timers.remove(this.sessionIdentifier);
        }
    }
}

