/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.common;

public enum MimeType {
    TEXT_PLAIN("txt", "text/plain"),
    TEXT_HTML("html", "text/html"),
    TEXT_CSS("css", "text/css"),
    TEXT_XML("xml", "text/xml"),
    IMAGE_ICO("ico", "image/vnd.microsoft.icon"),
    IMAGE_PNG("png", "image/png"),
    IMAGE_JPEG("jpeg", "image/jpeg"),
    IMAGE_GIF("gif", "image/gif"),
    APPLICATION_JS("js", "application/javascript");

    private String filenameExtension;
    private String mimeType;

    private MimeType(String filenameExtension, String mimeType) {
        this.filenameExtension = filenameExtension;
        this.mimeType = mimeType;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static MimeType fromFilenameExtension(String filenameExtension) {
        for (MimeType item : MimeType.values()) {
            if (!item.getFilenameExtension().equals(filenameExtension)) continue;
            return item;
        }
        return null;
    }

    public MimeType fromMineType(String mimeType) {
        for (MimeType item : MimeType.values()) {
            if (!item.getMimeType().equals(mimeType)) continue;
            return item;
        }
        return null;
    }
}

