/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import iso.std.iso_iec._24727.tech.schema.Transmit;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.ShortUtils;

public class ReadBinary
extends CardCommandAPDU {
    private static final byte READ_BINARY_INS_1 = -80;
    private static final byte READ_BINARY_INS_2 = -79;

    public ReadBinary() {
        super((byte)0, (byte)-80, (byte)0, (byte)-1);
    }

    public ReadBinary(byte offset) {
        super((byte)0, (byte)-80, offset, (byte)-1);
    }

    public ReadBinary(byte offset, byte length) {
        super((byte)0, (byte)-80, offset, length);
    }

    public ReadBinary(byte shortFileID, byte offset, short length) {
        super((byte)0, (byte)-80, (byte)(0x1F & shortFileID | 0x80), offset);
        this.setLE(length);
    }

    public ReadBinary(short offset, byte length) {
        this.setINS((byte)-80);
        this.setP1((byte)((byte)(offset >> 8) & 0x7F));
        this.setP2((byte)(offset & 0xFFFFFFFF));
        this.setLE(length);
    }

    public ReadBinary(short fileID, short offset, short length) {
        super((byte)0, (byte)-79, (byte)0, (byte)0);
        byte[] content = ShortUtils.toByteArray(offset);
        content = ByteUtils.concatenate((byte)84, content);
        this.setP1P2(ShortUtils.toByteArray(fileID));
        this.setData(content);
        this.setLE(length);
    }

    @Override
    public Transmit makeTransmit(byte[] slotHandle) {
        ArrayList<byte[]> defaultResponses = new ArrayList<byte[]>(){
            {
                this.add(new byte[]{-112, 0});
                this.add(new byte[]{98, -126});
            }
        };
        return this.makeTransmit(slotHandle, (List<byte[]>)defaultResponses);
    }
}

