/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http;

import java.io.IOException;
import org.openecard.apache.http.protocol.BasicHttpProcessor;
import org.openecard.control.binding.ControlBinding;
import org.openecard.control.binding.http.HTTPService;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.openecard.control.binding.http.handler.common.DefaultHandler;
import org.openecard.control.binding.http.handler.common.FileHandler;
import org.openecard.control.binding.http.handler.common.IndexHandler;
import org.openecard.control.binding.http.interceptor.CORSRequestInterceptor;
import org.openecard.control.binding.http.interceptor.CORSResponseInterceptor;
import org.openecard.control.binding.http.interceptor.ErrorResponseInterceptor;
import org.openecard.control.binding.http.interceptor.StatusLineResponseInterceptor;

public class HTTPBinding
extends ControlBinding {
    public static final int DEFAULT_PORT = 24727;
    private final int port;
    private final DocumentRoot documentRoot;
    private BasicHttpProcessor interceptors;
    private HTTPService service;

    public HTTPBinding() throws IOException, Exception {
        this(24727);
    }

    public HTTPBinding(int port) throws IOException, Exception {
        this(port, "/www", "/www-files");
    }

    public HTTPBinding(int port, String documentRootPath, String listFile) throws IOException, Exception {
        this.port = port;
        this.documentRoot = new DocumentRoot(documentRootPath, listFile);
    }

    public void setInterceptors(BasicHttpProcessor interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void start() throws Exception {
        if (this.interceptors == null || this.interceptors.getRequestInterceptorCount() == 0 || this.interceptors.getResponseInterceptorCount() == 0) {
            this.interceptors = new BasicHttpProcessor();
            this.interceptors.addInterceptor(new StatusLineResponseInterceptor());
            this.interceptors.addInterceptor(new ErrorResponseInterceptor(this.documentRoot, "/templates/error.html"));
            this.interceptors.addInterceptor(new CORSResponseInterceptor());
            this.interceptors.addInterceptor(new CORSRequestInterceptor());
        }
        this.handlers.addControlHandler(new IndexHandler());
        this.handlers.addControlHandler(new FileHandler(this.documentRoot));
        this.handlers.addControlHandler(new DefaultHandler());
        this.service = new HTTPService(this.port, this.handlers, this.interceptors);
        this.service.start();
    }

    @Override
    public void stop() throws Exception {
        this.service.interrupt();
    }

    public int getPort() {
        return this.service.getPort();
    }
}

