/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import java.io.ByteArrayOutputStream;
import java.util.List;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.util.ShortUtils;

public class EstablishPACERequest {
    private byte passwordType;
    private byte chatLength = 0;
    private byte[] chat;
    private byte passwordLength = 0;
    private byte[] password;
    private short certDescLength = 0;
    private byte[] certDesc;

    public EstablishPACERequest(byte passwordType, byte[] chat, byte[] password, byte[] certDesc) {
        this.passwordType = passwordType;
        if (chat != null) {
            this.chatLength = (byte)chat.length;
            this.chat = chat;
        }
        if (password != null) {
            this.passwordLength = (byte)password.length;
            this.password = password;
        }
        if (certDesc != null) {
            this.certDescLength = (short)certDesc.length;
            this.certDesc = certDesc;
        }
    }

    public boolean isSupportedType(List<PACECapabilities.PACECapability> capabilities) {
        if (this.chat == null && this.certDesc == null) {
            return capabilities.contains((Object)PACECapabilities.PACECapability.GenericPACE);
        }
        if (this.chat != null && this.certDesc != null) {
            return capabilities.contains((Object)PACECapabilities.PACECapability.GermanEID);
        }
        if (this.chat != null && this.certDesc == null) {
            return capabilities.contains((Object)PACECapabilities.PACECapability.QES);
        }
        return false;
    }

    public byte[] toBytes() {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(this.passwordType);
        if (this.chatLength > 0) {
            o.write(this.chatLength);
            if (this.chatLength > 0) {
                o.write(this.chat, 0, this.chat.length);
            }
            o.write(this.passwordLength);
            if (this.passwordLength > 0) {
                o.write(this.password, 0, this.password.length);
            }
            if (this.certDescLength > 0) {
                int i;
                byte[] dataLength_bytes = ShortUtils.toByteArray(this.certDescLength);
                for (i = dataLength_bytes.length - 1; i >= 0; --i) {
                    o.write(dataLength_bytes[i]);
                }
                for (i = dataLength_bytes.length; i < 2; ++i) {
                    o.write(0);
                }
                o.write(this.certDesc, 0, this.certDesc.length);
            }
        }
        return o.toByteArray();
    }
}

