/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.utils;

import java.util.StringTokenizer;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;

public final class ObjectIdentifierUtils {
    public static byte[] toByteArray(String oid) throws TLVException {
        TLV tlv = new TLV();
        tlv.setTagNum((byte)6);
        tlv.setValue(ObjectIdentifierUtils.getValue(oid));
        return tlv.toBER();
    }

    public static String toString(byte[] oid) throws TLVException {
        StringBuilder sb = new StringBuilder(32);
        if (oid[0] == 6) {
            oid = TLV.fromBER(oid).getValue();
        }
        switch ((oid[0] & 0x7F) / 40) {
            case 0: {
                sb.append('0');
                break;
            }
            case 1: {
                sb.append('1');
                break;
            }
            default: {
                sb.append('2');
            }
        }
        sb.append('.');
        for (int i = 0; i < oid.length; ++i) {
            sb.append(oid[i]);
            if (i >= oid.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static byte[] getValue(String oid) {
        StringTokenizer st = new StringTokenizer(oid, ".");
        byte[] ret = new byte[st.countTokens() - 1];
        if (oid.startsWith("0")) {
            st.nextElement();
        }
        int i = 0;
        while (st.hasMoreElements()) {
            int t = Integer.valueOf((String)st.nextElement());
            ret[i] = (byte)(t & 0xFF);
            ++i;
        }
        return ret;
    }
}

