/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.ASN1Set;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;

public final class PrivilegedTerminalInfo {
    private String protocol;
    private SecurityInfos privilegedTerminalInfo;

    public PrivilegedTerminalInfo(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Sequence wrong size for PrivilegedTerminalInfo");
        }
        this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
        this.privilegedTerminalInfo = SecurityInfos.getInstance((ASN1Set)seq.getObjectAt(1));
    }

    public static PrivilegedTerminalInfo getInstance(Object obj) {
        if (obj == null || obj instanceof PrivilegedTerminalInfo) {
            return (PrivilegedTerminalInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PrivilegedTerminalInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass().getName());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SecurityInfos getPrivilegedTerminalInfo() {
        return this.privilegedTerminalInfo;
    }
}

