/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.io.IOException;
import java.net.URI;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.entity.ContentType;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.ControlException;
import org.openecard.control.binding.http.HTTPException;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.handler.HttpControlHandler;
import org.openecard.control.module.status.GenericStatusHandler;
import org.openecard.control.module.status.StatusRequest;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.openecard.ws.schema.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStatusHandler
extends HttpControlHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpStatusHandler.class);
    private final WSMarshaller m;
    private final GenericStatusHandler genericStatusHandler;

    public HttpStatusHandler(GenericStatusHandler genericStatusHandler) {
        super("/getStatus");
        this.genericStatusHandler = genericStatusHandler;
        try {
            this.m = WSMarshallerFactory.createInstance();
            this.m.removeAllTypeClasses();
            this.m.addXmlTypeClass(Status.class);
        }
        catch (WSMarshallerException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws IOException {
        logger.debug("HTTP request: {}", (Object)request.toString());
        HttpResponse httpResponse = null;
        try {
            StatusRequest statusRequest = this.handleRequest(request);
            Status status = this.genericStatusHandler.handleRequest(statusRequest);
            httpResponse = this.handleResponse(status);
            response.setParams(request.getParams());
            Http11Response.copyHttpResponse(httpResponse, response);
        }
        catch (ControlException e) {
            block7: {
                httpResponse = new Http11Response(400);
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    httpResponse.setEntity(new StringEntity(e.getMessage(), "UTF-8"));
                }
                if (!(e instanceof HTTPException)) break block7;
                httpResponse.setStatusCode(((HTTPException)e).getHTTPStatusCode());
            }
            Http11Response.copyHttpResponse(httpResponse, response);
            logger.debug("HTTP response: {}", (Object)response);
            logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
        catch (Exception e2) {
            httpResponse = new Http11Response(500);
            logger.error(e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    Http11Response.copyHttpResponse(httpResponse, response);
                    logger.debug("HTTP response: {}", (Object)response);
                    logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
                    throw throwable;
                }
            }
            Http11Response.copyHttpResponse(httpResponse, response);
            logger.debug("HTTP response: {}", (Object)response);
            logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
        Http11Response.copyHttpResponse(httpResponse, response);
        logger.debug("HTTP response: {}", (Object)response);
        logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
    }

    private StatusRequest handleRequest(HttpRequest httpRequest) throws HTTPException {
        try {
            RequestLine requestLine = httpRequest.getRequestLine();
            if (requestLine.getMethod().equals("GET")) {
                URI requestURI = URI.create(requestLine.getUri());
                return this.genericStatusHandler.parseStatusRequestURI(requestURI);
            }
            throw new HTTPException(405);
        }
        catch (HTTPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HTTPException(400, e.getMessage());
        }
    }

    private HttpResponse handleResponse(Status status) throws HTTPException {
        try {
            Http11Response httpResponse = new Http11Response(202);
            String xml = this.m.doc2str(this.m.marshal(status));
            ContentType contentType = ContentType.create(ContentType.TEXT_XML.getMimeType(), "UTF-8");
            StringEntity entity = new StringEntity(xml, contentType);
            httpResponse.setEntity(entity);
            return httpResponse;
        }
        catch (Exception e) {
            throw new HTTPException(500, e.getMessage());
        }
    }
}

