/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg.sig;

import org.openecard.bouncycastle.bcpg.SignatureSubpacket;

public class Features
extends SignatureSubpacket {
    public static final byte FEATURE_MODIFICATION_DETECTION = 1;

    private static final byte[] featureToByteArray(byte feature) {
        byte[] data = new byte[]{feature};
        return data;
    }

    public Features(boolean critical, byte[] data) {
        super(30, critical, data);
    }

    public Features(boolean critical, byte feature) {
        super(30, critical, Features.featureToByteArray(feature));
    }

    public boolean supportsModificationDetection() {
        return this.supportsFeature((byte)1);
    }

    public boolean supportsFeature(byte feature) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != feature) continue;
            return true;
        }
        return false;
    }

    private void setSupportsFeature(byte feature, boolean support) {
        if (feature == 0) {
            throw new IllegalArgumentException("feature == 0");
        }
        if (this.supportsFeature(feature) != support) {
            if (support) {
                byte[] temp = new byte[this.data.length + 1];
                System.arraycopy(this.data, 0, temp, 0, this.data.length);
                temp[this.data.length] = feature;
                this.data = temp;
            } else {
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] != feature) continue;
                    byte[] temp = new byte[this.data.length - 1];
                    System.arraycopy(this.data, 0, temp, 0, i);
                    System.arraycopy(this.data, i + 1, temp, i, temp.length - i);
                    this.data = temp;
                    i = this.data.length + 1;
                }
            }
        }
    }
}

