/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins;

import java.io.FilePermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.PropertyPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginPolicy
extends Policy {
    private static final Logger logger = LoggerFactory.getLogger(PluginPolicy.class);
    private final PermissionCollection allowedPermissions;
    private final String pluginPath;

    public PluginPolicy(String path) {
        this.pluginPath = path.replace("\\", "/");
        this.allowedPermissions = new Permissions();
        this.allowedPermissions.add(new FilePermission("<<ALL FILES>>", "read"));
        this.allowedPermissions.add(new PropertyPermission("line.separator", "read"));
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        CodeSource source = domain.getCodeSource();
        URL loc = source.getLocation();
        Certificate[] certs = source.getCertificates();
        if (loc == null && certs == null) {
            return true;
        }
        if (loc != null && loc.toString().contains(this.pluginPath)) {
            logger.debug("Plugin {} is requesting permission {}", (Object)loc, (Object)permission);
            boolean granted = this.allowedPermissions.implies(permission);
            logger.debug("Access granted: {}", (Object)granted);
            return granted;
        }
        return true;
    }
}

