/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import org.openecard.common.I18n;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.control.module.tctoken.gui.InsertCardStepAction;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.gui.executor.StepAction;

public class InsertCardDialog {
    private static final String STEP_ID = "insert-card";
    private final I18n lang = I18n.getTranslation("tctoken");
    private final UserConsent gui;
    private final String cardType;
    private final String cardName;
    private CardStateMap cardStates;

    public InsertCardDialog(UserConsent gui, CardStateMap cardStates, String cardType, String cardName) {
        this.gui = gui;
        this.cardType = cardType;
        this.cardName = cardName;
        this.cardStates = cardStates;
    }

    public ConnectionHandleType show() {
        InsertCardStepAction insertCardAction = new InsertCardStepAction(STEP_ID, this.cardStates, this.cardType);
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createInsertCardUserConsent(insertCardAction));
        ExecutionEngine exec = new ExecutionEngine(ucr);
        ResultStatus status = exec.process();
        if (status == ResultStatus.CANCEL) {
            return null;
        }
        return insertCardAction.getResponse();
    }

    private UserConsentDescription createInsertCardUserConsent(StepAction insertCardAction) {
        UserConsentDescription uc = new UserConsentDescription(this.lang.translationForKey("title", new Object[0]));
        Step s = new Step(STEP_ID, this.lang.translationForKey("step.title", new Object[0]));
        s.setInstantReturn(true);
        s.setAction(insertCardAction);
        Text i1 = new Text();
        i1.setText(this.lang.translationForKey("step.message", this.cardName));
        s.getInputInfoUnits().add(i1);
        uc.getSteps().add(s);
        return uc;
    }
}

