/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestExecutor;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.openecard.common.io.LimitedInputStream;
import org.openecard.common.io.ProxySettings;
import org.openecard.common.util.FileUtils;
import org.openecard.common.util.Pair;
import org.openecard.common.util.TR03112Utils;
import org.openecard.control.ControlException;
import org.openecard.control.module.tctoken.TCTokenException;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.TlsNoAuthentication;
import org.openecard.transport.httpcore.HttpRequestHelper;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenGrabber {
    private static final Logger logger = LoggerFactory.getLogger(TCTokenGrabber.class);

    public static Pair<InputStream, List<Pair<URL, Certificate>>> getStream(URL url) throws TCTokenException, MalformedURLException, IOException, HttpException, URISyntaxException {
        HttpEntity entity = null;
        int maxRedirects = 10;
        boolean finished = false;
        ArrayList<Pair<URL, Certificate>> serverCerts = new ArrayList<Pair<URL, Certificate>>();
        while (!finished) {
            TlsProtocolHandler h;
            logger.info("Trying to load resource from: {}", (Object)url);
            if (maxRedirects == 0) {
                throw new ControlException("Maximum number of redirects exceeded..");
            }
            --maxRedirects;
            String protocol = url.getProtocol();
            String hostname = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String resource = url.getFile();
            if (!"https".equals(protocol)) {
                throw new ControlException("Specified URL is not a https-URL.");
            }
            TlsNoAuthentication tlsAuth = new TlsNoAuthentication();
            ClientCertDefaultTlsClient tlsClient = new ClientCertDefaultTlsClient(hostname);
            tlsClient.setAuthentication(tlsAuth);
            try {
                tlsClient.setClientVersion(ProtocolVersion.TLSv11);
                Socket socket = ProxySettings.getDefault().getSocket(hostname, port);
                h = new TlsProtocolHandler(socket.getInputStream(), socket.getOutputStream());
                h.connect(tlsClient);
            }
            catch (IOException e) {
                logger.error("Connecting to the TCToken-URL with TLSv1.1 failed. Falling back to TLSv1.0.");
                tlsClient.setClientVersion(ProtocolVersion.TLSv10);
                Socket socket = ProxySettings.getDefault().getSocket(hostname, port);
                h = new TlsProtocolHandler(socket.getInputStream(), socket.getOutputStream());
                h.connect(tlsClient);
            }
            serverCerts.add(new Pair<URL, Certificate>(url, tlsAuth.getServerCertificate()));
            StreamHttpClientConnection conn = new StreamHttpClientConnection(h.getInputStream(), h.getOutputStream());
            BasicHttpContext ctx = new BasicHttpContext();
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("GET", resource);
            req.setParams(conn.getParams());
            HttpRequestHelper.setDefaultHeader((HttpRequest)req, url);
            req.setHeader("Accept", "text/xml, */*;q=0.8");
            req.setHeader("Accept-Charset", "utf-8, *;q=0.8");
            HttpResponse response = httpexecutor.execute(req, conn, ctx);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (TR03112Utils.isRedirectStatusCode(statusCode)) {
                Header[] headers = response.getHeaders("Location");
                if (headers.length > 0) {
                    String uri = headers[0].getValue();
                    url = new URL(uri);
                    continue;
                }
                String msg = "Resource could not be retrieved. Missing Location header in HTTP response.";
                throw new TCTokenException(msg);
            }
            conn.receiveResponseEntity(response);
            entity = response.getEntity();
            finished = true;
        }
        LimitedInputStream is = new LimitedInputStream(entity.getContent());
        return new Pair<InputStream, List<Pair<URL, Certificate>>>(is, Collections.unmodifiableList(serverCerts));
    }

    public static Pair<String, List<Pair<URL, Certificate>>> getResource(@Nonnull URL url) throws IOException {
        FilterInputStream is = null;
        try {
            Pair<InputStream, List<Pair<URL, Certificate>>> data = TCTokenGrabber.getStream(url);
            is = new LimitedInputStream((InputStream)data.p1);
            String stringData = FileUtils.toString(is);
            Pair<String, List<Pair<URL, Certificate>>> pair = new Pair<String, List<Pair<URL, Certificate>>>(stringData, (List<Pair<URL, Certificate>>)data.p2);
            return pair;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
    }
}

