/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.DataElements;
import org.openecard.common.util.ByteUtils;

public class FCP {
    private final TLV tlv;
    private Long numBytes;
    private Long numBytesStructure;
    private DataElements dataElements;
    private List<byte[]> fileIdentifiers = new LinkedList<byte[]>();
    private List<byte[]> dfNames = new LinkedList<byte[]>();
    private List<byte[]> proprietaryInformationNoTLV = new LinkedList<byte[]>();
    private List<byte[]> proprietarySecurityAttribute = new LinkedList<byte[]>();
    private byte[] fciExtensionEf;
    private byte[] shortEfIdentifier;
    private Byte lifeCycleStatusByte;
    private byte[] securityAttributeReferenceExpanded;
    private byte[] securityAttributeCompact;
    private List<byte[]> securityEnvironmentTemplateEfs = new LinkedList<byte[]>();
    private Byte channelSecurityAttribute;
    private byte[] securityAttributeTemplateForDataObject;
    private byte[] securityAttributeTemplateProprietary;
    private List<TLV> dataObjectTemplates = new LinkedList<TLV>();
    private TLV proprietaryInformationTLV;
    private byte[] securityAttributeTemplateExpanded;
    private byte[] cryptographicMechanismIdentifierTemplate;

    public FCP(TLV tlv) throws TLVException {
        TLV next;
        this.tlv = tlv;
        if (tlv.getTagNumWithClass() != 98L) {
            throw new TLVException("Data doesn't represent an FCP.");
        }
        LinkedList<byte[]> descriptorBytes = new LinkedList<byte[]>();
        Parser p = new Parser(tlv.getChild());
        while ((next = p.next(0)) != null) {
            if (next.getTagNumWithClass() == 128L) {
                this.numBytes = new Long(ByteUtils.toLong(next.getValue()));
            }
            if (next.getTagNumWithClass() == 129L) {
                this.numBytesStructure = new Long(ByteUtils.toLong(next.getValue()));
            }
            if (next.getTagNumWithClass() == 130L) {
                descriptorBytes.add(next.getValue());
            }
            if (next.getTagNumWithClass() == 131L) {
                this.fileIdentifiers.add(next.getValue());
            }
            if (next.getTagNumWithClass() == 132L) {
                this.dfNames.add(next.getValue());
            }
            if (next.getTagNumWithClass() == 133L) {
                this.proprietaryInformationNoTLV.add(next.getValue());
            }
            if (next.getTagNumWithClass() == 134L) {
                this.proprietarySecurityAttribute.add(next.getValue());
            }
            if (next.getTagNumWithClass() == 135L) {
                this.fciExtensionEf = next.getValue();
            }
            if (next.getTagNumWithClass() == 136L) {
                this.shortEfIdentifier = next.getValue();
            }
            if (next.getTagNumWithClass() == 138L) {
                this.lifeCycleStatusByte = new Byte(next.getValue()[0]);
            }
            if (next.getTagNumWithClass() == 139L) {
                this.securityAttributeReferenceExpanded = next.getValue();
            }
            if (next.getTagNumWithClass() == 140L) {
                this.securityAttributeCompact = next.getValue();
            }
            if (next.getTagNumWithClass() == 141L) {
                this.securityEnvironmentTemplateEfs.add(next.getValue());
            }
            if (next.getTagNumWithClass() == 142L) {
                this.channelSecurityAttribute = new Byte(next.getValue()[0]);
            }
            if (next.getTagNumWithClass() == 160L) {
                this.securityAttributeTemplateForDataObject = next.getValue();
            }
            if (next.getTagNumWithClass() == 161L) {
                this.securityAttributeTemplateProprietary = next.getValue();
            }
            if (next.getTagNumWithClass() == 162L) {
                this.dataObjectTemplates.add(next);
            }
            if (next.getTagNumWithClass() == 165L) {
                this.proprietaryInformationTLV = next;
            }
            if (next.getTagNumWithClass() == 171L) {
                this.securityAttributeTemplateExpanded = next.getValue();
            }
            if (next.getTagNumWithClass() != 172L) continue;
            this.cryptographicMechanismIdentifierTemplate = next.getValue();
        }
        this.dataElements = new DataElements(descriptorBytes);
    }

    public FCP(byte[] data) throws TLVException {
        this(TLV.fromBER(data));
    }

    public byte[] toBER() {
        try {
            return this.tlv.toBER();
        }
        catch (TLVException ex) {
            return null;
        }
    }

    public Long getNumBytes() {
        return this.numBytes;
    }

    public DataElements getDataElements() {
        return this.dataElements;
    }

    public List<byte[]> fileIdentifiers() {
        return this.fileIdentifiers;
    }

    public List<byte[]> DF_Names() {
        return this.dfNames;
    }

    public String toString(String prefix) {
        StringBuilder b = new StringBuilder(4096);
        String indent = prefix + " ";
        String subindent = indent + " ";
        b.append(prefix);
        b.append("FCP:\n");
        b.append(indent);
        b.append("num-bytes=");
        b.append(this.numBytes);
        b.append(" num-bytes-structure=");
        b.append(this.numBytesStructure);
        b.append("\n");
        b.append(this.dataElements.toString(indent));
        b.append("\n");
        b.append(indent);
        b.append("File-Identifiers:\n");
        for (byte[] byArray : this.fileIdentifiers) {
            b.append(subindent);
            b.append(ByteUtils.toHexString(byArray));
            b.append("\n");
        }
        b.append("DF-Names:\n");
        for (byte[] byArray : this.dfNames) {
            b.append(subindent);
            b.append(ByteUtils.toHexString(byArray));
            b.append("\n");
        }
        if (this.shortEfIdentifier != null) {
            b.append(indent);
            b.append("short-EF-identifier: ");
            b.append(ByteUtils.toHexString(this.shortEfIdentifier));
            b.append("\n");
        }
        b.append(indent);
        b.append("DataObjectTemplates:\n");
        for (TLV tLV : this.dataObjectTemplates) {
            b.append(subindent);
            b.append("DataObjectTemplate:");
            b.append(tLV.toString(subindent + " "));
            b.append("\n");
        }
        return b.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

