/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsUtil {
    private static final Logger logger = LoggerFactory.getLogger(GraphicsUtil.class);

    public static Image createImage(Class<?> clazz, int imageWidth, int imageHeight) {
        return GraphicsUtil.createImage(clazz, imageWidth, imageHeight, imageWidth, imageHeight, 0, 0);
    }

    public static Image createImage(Class<?> clazz, int imageWidth, int imageHeight, int canvasWidth, int canvasHeight, int posX, int posY) {
        BufferedImage image = new BufferedImage(canvasWidth, canvasHeight, 2);
        Graphics2D g = image.createGraphics();
        try {
            Object svgIcon = clazz.newInstance();
            Method method = clazz.getMethod("setDimension", Dimension.class);
            method.invoke(svgIcon, new Dimension(imageWidth, imageHeight));
            method = clazz.getMethod("paintIcon", Component.class, Graphics.class, Integer.TYPE, Integer.TYPE);
            method.invoke(svgIcon, null, g, posX, posY);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
        return image;
    }
}

