/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.DERIA5String;
import org.openecard.crypto.common.asn1.eac.FileID;

public final class CardInfoLocator {
    private String protocol;
    private String url;
    private FileID efCardInfo;

    public CardInfoLocator(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.url = DERIA5String.getInstance(seq.getObjectAt(1)).getString();
        } else if (seq.size() == 3) {
            this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.url = DERIA5String.getInstance(seq.getObjectAt(1)).getString();
            this.efCardInfo = FileID.getInstance(seq.getObjectAt(2));
        } else {
            throw new IllegalArgumentException("Sequence wrong size for CardInfoLocator");
        }
    }

    public static CardInfoLocator getInstance(Object obj) {
        if (obj == null || obj instanceof CardInfoLocator) {
            return (CardInfoLocator)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CardInfoLocator((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass().getName());
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public String getURL() {
        return this.url;
    }

    public FileID getEFCardInfo() {
        return this.efCardInfo;
    }
}

