/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthDataMap {
    private static final String isoNs = "urn:iso:std:iso-iec:24727:tech:schema";
    private final String protocol;
    private final HashMap<QName, Element> contentMap = new HashMap();
    private final HashMap<QName, String> attributeMap;
    private final Document xmlDoc;

    public AuthDataMap(DIDAuthenticationDataType data) throws ParserConfigurationException {
        this.protocol = data.getProtocol();
        List<Element> content = data.getAny();
        for (Element next : content) {
            String name = next.getLocalName();
            String ns = next.getNamespaceURI();
            QName qname = new QName(ns, name);
            this.contentMap.put(qname, next);
        }
        this.attributeMap = new HashMap<QName, String>(data.getOtherAttributes());
        this.xmlDoc = content.isEmpty() ? this.loadXMLBuilder() : content.get(0).getOwnerDocument();
    }

    private Document loadXMLBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public AuthDataResponse createResponse(DIDAuthenticationDataType responseObj) {
        responseObj.setProtocol(this.protocol);
        return new AuthDataResponse(this.xmlDoc, responseObj);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean containsContent(QName qname) {
        return this.contentMap.containsKey(qname);
    }

    public boolean containsContent(String ns, String localName) {
        return this.containsContent(new QName(ns, localName));
    }

    public boolean containsContent(String localName) {
        return this.containsContent(new QName(isoNs, localName));
    }

    public Element getContent(QName qname) {
        return this.contentMap.get(qname);
    }

    public Element getContent(String ns, String localName) {
        return this.getContent(new QName(ns, localName));
    }

    public Element getContent(String localName) {
        return this.getContent(new QName(isoNs, localName));
    }

    public String getContentAsString(QName qname) {
        if (this.containsContent(qname)) {
            Element content = this.getContent(qname);
            String contentStr = content.getTextContent();
            return contentStr;
        }
        return null;
    }

    public String getContentAsString(String ns, String localName) {
        return this.getContentAsString(new QName(ns, localName));
    }

    public String getContentAsString(String localName) {
        return this.getContentAsString(new QName(isoNs, localName));
    }

    public byte[] getContentAsBytes(QName qname) {
        if (this.containsContent(qname)) {
            String content = this.getContentAsString(qname);
            byte[] contentBytes = StringUtils.toByteArray(content, true);
            return contentBytes;
        }
        return null;
    }

    public byte[] getContentAsBytes(String ns, String localName) {
        return this.getContentAsBytes(new QName(ns, localName));
    }

    public byte[] getContentAsBytes(String localName) {
        return this.getContentAsBytes(new QName(isoNs, localName));
    }

    public boolean containsAttribute(QName qname) {
        return this.attributeMap.containsKey(qname);
    }

    public boolean containsAttribute(String ns, String name) {
        return this.containsAttribute(new QName(ns, name));
    }

    public boolean containsAttribute(String name) {
        return this.containsAttribute(new QName(isoNs, name));
    }

    public String getAttribute(QName qname) {
        return this.attributeMap.get(qname);
    }

    public String getAttribute(String ns, String name) {
        return this.getAttribute(new QName(ns, name));
    }

    public String getAttribute(String name) {
        return this.getAttribute(new QName(isoNs, name));
    }
}

