/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.crypto.CryptoException;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.openecard.bouncycastle.crypto.agreement.srp.SRP6Util;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.io.SignerInputStream;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.TlsClientContext;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsDSSSigner;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsRSASigner;
import org.openecard.bouncycastle.crypto.tls.TlsSigner;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.crypto.util.PublicKeyFactory;
import org.openecard.bouncycastle.util.BigIntegers;

class TlsSRPKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsSigner tlsSigner;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected byte[] s = null;
    protected BigInteger B = null;
    protected SRP6Client srpClient = new SRP6Client();

    TlsSRPKeyExchange(TlsClientContext context, int keyExchange, byte[] identity, byte[] password) {
        switch (keyExchange) {
            case 21: {
                this.tlsSigner = null;
                break;
            }
            case 23: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 22: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = context;
        this.keyExchange = keyExchange;
        this.identity = identity;
        this.password = password;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        org.openecard.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        byte[] sigByte;
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        InputStream sigIn = is;
        Signer signer = null;
        if (this.tlsSigner != null) {
            signer = this.initSigner(this.tlsSigner, securityParameters);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] NBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] sBytes = TlsUtils.readOpaque8(sigIn);
        byte[] BBytes = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            throw new TlsFatalAlert(42);
        }
        BigInteger N = new BigInteger(1, NBytes);
        BigInteger g = new BigInteger(1, gBytes);
        this.s = sBytes;
        try {
            this.B = SRP6Util.validatePublicValue(N, new BigInteger(1, BBytes));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47);
        }
        this.srpClient.init(N, g, new SHA1Digest(), this.context.getSecureRandom());
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        byte[] keData = BigIntegers.asUnsignedByteArray(this.srpClient.generateClientCredentials(this.s, this.identity, this.password));
        TlsUtils.writeOpaque16(keData, os);
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.srpClient.calculateSecret(this.B));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

